<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StuffOrderRequest extends FormRequest
{


    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages() {
        $messages = [];
        foreach($this->request->get('name') as $key => $val) {
            $messages['name.'.$key.'.required'] = ' در فیلد شماره ' . $key .' ،نام کالا را وارد کنید';
            $messages['name.'.$key.'.string'] = ' در فیلد شماره ' . $key .' ،نام کالا باید شامل حروف و عدد باشد کنید';
            $messages['name.'.$key.'.max'] = ' در فیلد شماره ' . $key .' ،نام کالا مجاز به استفاده از 250 کاراکتر می باشید';

        }
        foreach($this->request->get('engName') as $key => $val) {
            $messages['engName.'.$key.'.required'] = ' در فیلد شماره ' . $key .' ،نام انگلیسی کالا را وارد کنید';
            $messages['engName.'.$key.'.string'] = ' در فیلد شماره ' . $key .' ،نام انگلیسی کالا باید شامل حروف و عدد باشد کنید';
            $messages['engName.'.$key.'.max'] = ' در فیلد شماره ' . $key .' ،نام انگلیسی کالا مجاز به استفاده از 250 کاراکتر می باشید';
        }
        foreach($this->request->get('price') as $key => $val) {
            $messages['price.'.$key.'.required'] = ' در فیلد شماره ' . $key .' ،قیمت را وارد کنید';
        }
        foreach($this->request->get('qty') as $key => $val) {
            $messages['qty.'.$key.'.required'] = ' در فیلد شماره ' . $key .' ،تعداد را وارد کنید';
        }

        return $messages;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = array();


        foreach($this->request->get('name') as $key => $val) {
            $rules['name.'.$key] = 'required|string|max:250';
        }

        foreach($this->request->get('engName') as $key => $val) {
            $rules['engName.'.$key] = 'required|string|max:250';
        }

        foreach($this->request->get('price') as $key => $val) {
            $rules['price.'.$key] = 'required|integer|numeric|min:0';
        }

        foreach($this->request->get('qty') as $key => $val) {
            $rules['qty.'.$key] = 'required|integer|numeric|min:0';
        }


        return $rules;
    }
}
