<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StepTwoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
    
        return [
            'fname'             => ['required','max:60'],
            'lname'             => ['required','max:60'],
            'melli_code'        =>['required'],
            'tell'              => ['required'],
            'urgent_phone_no'   => ['required'],
            'state'             => 'required|string|exists:provinces,name',
            'gender'            => 'required|min:0|max:1',
            'city'              => 'required|string|exists:cities,name',
            'postal_code'       => 'required',
            'address'           => 'required|max:300'
        ];

    }
}
