<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SliderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if($this->method() == 'PUT') {
            return [
                'type' => 'required',
                'name' => 'required',
                'status' => 'numeric|max:1',
                'order' => 'required|numeric',
            ];
        }
        return [
            'type' => 'required',
            'name' => 'required',
            'status' => 'numeric|max:1',
            'order' => 'required|numeric',
            'image' => 'required|mimes:jpeg,bmp,png|max:500',
        ];
    }
}
