<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ServiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if($this->method() == 'POST') {
            return [
                'title' => 'required',
                'url' => 'required',
                'order' => 'required|numeric',
                'image' => 'required|mimes:jpeg,bmp,png|max:500',
            ];
        }
        return [
            'title' => 'required',
            'url' => 'required',
            'order' => 'required|numeric',
        ];
    }
}
