<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ReviewRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }


    public function messages()
    {
        return [
            'name.required'           => 'برای فرستادن نظر، حتما باید نام خود را وارد کنید',
            'name.string'            => 'در فیلد نام فقط حق استفاده از حروف و اعداد دارید',
            'text.required'             => 'برای فرستادن نظر، حتما باید نظر خود را بنویسید',
            'text.string'               => 'در قسمت نظر فقط مجاز به استفاده از حروف و اعداد دارید',
            'review_rate.required'             => 'قبل از ارسال نظر حتما به این کالا امتیاز دهید',
            'review_rate.integer'               => 'امتیاز کالا فقط می تواند عدد باشد',
            'review_rate.min'             => 'حداقل مقدار مجاز امتیاز برای کالا 1 می باشد',
            'review_rate.max'               => 'حداقل مقدار مجاز امتیاز برای کالا 5 می باشد',

            'product_id.required'             => 'آی دی کالا لازم است',
            'product_id.integer'               => 'محصول فقط می تواند عدد باشد',
            'product_id.min'             => 'حداقل مقدار محصول برای کالا 1 می باشد',
        ];
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|string',
            'text' => 'required|string',
            'review_rate' => 'required|integer|min:1|max:5',
            'product_id' => 'required|integer|min:1'
        ];
    }
}
