<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }


    public function messages()
    {
        return [
            'userId.required' => 'آی دی کاربر لازم است',
            'userId.integer' => 'آی دی کاربر باید عدد باشد',

            'userName.required' =>'لطفا نام کاربری را وارد کنید',
            'userName.string' =>'نام کاربری باید حروف انگلیسی باشد',
            'userName.max' => 'نام کاربری نمی تواند بیش از 60 کاراکتر باشد.',

            'email.required' => 'لطفا ایمیل خود را وارد کنید.',
            'email.unique' => 'این ایمیل قبلا استفاده شده است.',
            'email.email' => 'لطفا یک ایمیل معتبر وارد کنید.',


        ];
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'userId' => 'required|integer',
            'userName' =>'required|string|max:60',
//            'email'=>'required|unique:users|email',
        ];
    }
}
