<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }


    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = array();
        $rules['name']                  = ['required','string','unique:products'];
        $rules['eng_name']              = ['required','string','unique:products'];
        $rules['brand_id']              = ['required','numeric','min:1','exists:brands,id'];
        $rules['category_id']           = ['required','numeric','min:1','exists:category,id'];
        $rules['base_sell_price']       = ['required','numeric','min:1000'];
        $rules['discount_sell_price']   = ['nullable','numeric','min:1000'];
        $rules['alarm_level']           = ['required','numeric','min:1'];
        $rules['weight']                = ['required','numeric','min:1'];
        $rules['qty']                   = ['required','numeric','min:1'];
        $rules['buy']                   = ['required','numeric','min:100'];

        return $rules;
    }
}
