<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PasswordResetRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages() {
        return [
            'old_password.required' => 'لطفا رمز عبور خود را وارد نمایید.',
            'old_password.max' => 'رمزعبور نمی تواند بیش از 60 کاراکتر باشد.',
            'old_password.min' => 'رمزعبور نمی تواند کمتر از 8 کاراکتر باشد.',
            'password.required' => 'لطفا رمز عبور خود را وارد نمایید.',
            'password.max' => 'رمزعبور نمی تواند بیش از 60 کاراکتر باشد.',
            'password.min' => 'رمزعبور نمی تواند کمتر از 8 کاراکتر باشد.',
            'password.confirmed' => 'رمز عبور و تکرار آن با هم یکی نیستند',
            'password_confirmation.max' => 'تکرار رمزعبور نمی تواند بیش از 60 کاراکتر باشد.',
            'password_confirmation.min' => 'تکرار رمزعبور نمی تواند کمتر از 8 کاراکتر باشد.',
        ];
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "old_password" => 'required|max:60|min:6',
            'password'=>'required|max:60|min:6|confirmed',
            'password_confirmation' => 'max:60|min:6',
        ];
    }
}
