<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class InventoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
    public function messages()
    {
        return [
            'inv_id.required'         => 'نام کالا الزامی است',
            'inv_id.regex'            => 'لطفا در نام کالا از حروف فارسی، انگلیسی و اعدد انگلیسی استفاده کنید',
            'numNoColor.numeric'    => 'لطفا تعداد کالای مصرفی را به صورت عددی وارد کنید',
            'numNoColor.min'        => 'تعداد کالای مصرفی بدون رنگ حداقل باید 1 عدد باشد',
            'num.numeric'           => 'لطفا تعداد کالای مصرفی را به صورت عددی وارد کنید',
            'num.min'               => 'تعداد کالای مصرفی حداقل باید 1 عدد باشد',
            'pColorId.required'     => 'آیدی کالا مورد نیاز است',
            'pColorId.numeric'      => 'آیدی کالا باید عددی باشد',

        ];
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [

            'inv_id'          => ['required','regex:/^[a-zA-Z0-9 اآبپتثجچحخدذرزژسشصضطظعغفقکگلمنوهی]+$/'],
            'numNoColor'    => ['numeric','nullable','min:1'],
        ];

        for ($i = 0; $i < count($this->num); $i++) {

            $rules['num.' . $i ] = ['numeric','nullable','min:1'];
            $rules['pColorId.' . $i ] = ['required','numeric'];
        }
        return $rules;
    }
}
