<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FilterTitleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return [
            'category_id.required'         => 'دسته بندی لازم است',
            'category_id.integer'         => 'دسته بندی باید عدد باشد',

            'name.required'         => 'لطفا عنوان فیلتر را وارد کنید',
            'name.string'         => 'عنوان فیلتر باید حرف یا عدد باشد',

            'priority.required'         => 'لطفا فیلد الویت را وارد کنید',
            'priority.integer'         => 'اولویت باید به صورت عددی باشد',

            'status.required'         => 'لطفا یکی از وضعیت ها را مشخص کنید',
            'status.integer'         => 'وضعیت باید به صورت عددی باشد',

        ];
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'category_id' => 'required|integer',
            'name' => 'required|string',
            'priority' => 'required|integer',
            'status' => 'required|integer'
        ];
    }
}
