<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FilterOptionsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        return [
            'title_id'      => 'required|numeric|exists:filter_titles,id',
            'name'          => 'required|string',
            'tec_code'      => 'required|string|exists:products_tecinfo,code',
            'tec_id'        => 'required|numeric|exists:tec_info_products,tec_id',
            'priority'      => 'required|numeric|min:1',
            'status'        => 'required|numeric|min:0|max:1'
        ];
    }
}
