<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DynamicMenuRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return [
        'name.required'         =>  'نوشتن نام الزامی است',
        'name.unique'           =>  ' قبلا به این نام منو ثبت شده',
        'name.string'           =>  'فقط مجاز با استفاده از حروف هستید',
        'name.max'              =>  'حداکثر کاراکتر مجاز ۱۰۰ کاراکتر می باشد'
        ];
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|unique:dynamic_menus|string|max:100',
            'stuffType_id' => 'required|integer',
        ];
    }
}
