<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DiscountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return [
            'amount.required'           => 'مقدار تخفیف حتما باید وارد شود',
            'amount.integer'            => 'مقدار تخفیف فقط باید به صورت عدد باشد',
            'amount.min'                => 'حداقل مقدار درصد تخفیف 1% و کمترین مقدار پولی تخفیف 1000 تومان است',
            'amount.max'                => 'حداکثر میزان درصد تخفیف 100% است',

            'date.required'             => 'تاریخ اعتبار را حتما باید وارد کنید',
            'date.string'               => 'تاریخ به صورت عددی می باشد',

            'time.required'             => 'ساعت اعتبار باید حتما وارد شود',
            'time.string'               => 'زمان اعتبار باید فقط به صورت عددی باشد',

            'number.required'           => 'فیلد تعداد دفعات استفاده حتما باید مشخص شود',
            'number.integer'            => 'فیلد تعداد دفعات استفاده باید فقط به صورت عدد وارد شود',
            'number.min'                => 'حداقل مقدار تعداد دفعات استفاده 1 دفعه است',
            'number.max'                => 'حداکثر مقدار تعداد دفعات استفاده 30 دفعه است',

        ];
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = array();

        $discount_type = $this->request->get('discount_type');

        $rules['price_up']      = ['nullable','integer','min:0'];
        $rules['price_down']    = ['nullable','integer','min:0'];

        if ($discount_type == 10 || $discount_type == 20 || $discount_type == 30 || $discount_type == 40) {
            $rules['amount'] = ['required','integer','min:1000'];
            if($discount_type == 20){
                $rules['date'] = ['required','string'];
                $rules['time'] = ['required','string'];
            }elseif($discount_type == 30){
                $rules['number'] = ['required','integer','min:1','max:30'];

            }elseif($discount_type == 40){
                $rules['date'] = ['required','string'];
                $rules['time'] = ['required','string'];
                $rules['number'] = ['required','integer','min:1','max:30'];
            }
        }elseif($discount_type == 11 || $discount_type == 21 || $discount_type == 31 || $discount_type == 41){
            $rules['amount'] = ['required','integer','min:1','max:100'];
            if($discount_type == 21){
                $rules['date'] = ['required','string'];
                $rules['time'] = ['required','string'];
            }elseif($discount_type == 31){
                $rules['number'] = ['required','integer','min:1','max:30'];
            }elseif($discount_type == 41){
                $rules['date'] = ['required','string'];
                $rules['time'] = ['required','string'];
                $rules['number'] = ['required','integer','min:1','max:30'];
            }
        }

        return $rules;
    }
}
