<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DiscountDeleteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return [
            'discount_code_id.required'           => 'شناسه کد تخفیف حتما باید وارد شود',
            'discount_code_id.integer'            => 'شناسه کد تخفیف فقط باید به صورت عدد باشد',
            'discount_code_id.min'                => 'حداقل مقدار شناسه کد تخفیف 1 می باشد',
            'discount_code_id.exists'                => 'چنین کد تخفیفی با این شناسه وجود ندارد',

        ];
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'discount_code_id' => 'required|integer|min:1|exists:discount_codes,id'
        ];
    }
}
