<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ColorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return [

            'product_id.required'           => 'آی دی محصول نیاز است',
            'product_id.numeric'            => 'آی دی محصول باید عددی باشد',
            'product_colorName.required'    => 'نام محصول مورد نیاز است',
            'product_colorName.regex'       => 'نام محصول باید حروف فارسی، انگلیسی و اعداد انگلیسی باشد',
            'qty.required'               => 'تعداد محصول باید مقدار دهی شود',
            'qty.numeric'                => 'تعداد محصول باید به شکل عددی باشد',
            'qty.min'                    => 'حداقل تعداد محصول ۱ عدد می باشد',
            'colorBasePrice.numeric'        => 'قیمت فروش محصول باید عددی باشد',
            'colorDiscountPrice.numeric'    => 'قیمت فروش محصول باید عددی باشد',
            'priority.required' => 'لطفا اولویت را وارد کنید',
            'priority.integer' => 'اولویت فقط باید به صورت عددی وارد شود',
            'priority.min' => 'اولویت حداقل باید یک باشد',

            'status.required' => 'یکی از وضعیت ها را حتما انتخاب کنید',
            'status.boolean' => 'وضعیت یا فعال و یا باید غیر فعال باشد',
        ];
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'product_id'            =>  'required|numeric',
            'product_colorName'     =>  ['required','regex:/^[a-zA-Z0-9 اآبپتثجچحخدذرزژسشصضطظعغفقکگلمنوهی]+$/'],
            'qty'                =>  'required|numeric|min:1',
            'colorBasePrice'        =>  'nullable|numeric',
            'colorDiscountPrice'    =>  'nullable|numeric',
            'priority'              =>  'required|integer|min:1',
            'status'                =>  'required|boolean',
        ];
    }
}
