<?php

namespace App\Http\Controllers\SiteFront;

use App\Http\Controllers\Controller;
use App\Models\Cart;
use App\Models\Favorite;
use App\Models\MsParticipant;
use App\Models\Province;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Morilog\Jalali\jDate;

class ProfileController extends Controller
{
    protected function index(){

        if(Auth::check()){
            $user = User::whereId(Auth::id())->first();


            $userCarts = Cart::where('user_id',Auth::id())->where('paid',1)->latest()->get();

            $orders = array();

            foreach ($userCarts as $userCart){
                $orders[] = $userCart->Payment()->first();
            }

            $favorites = Favorite::where('user_id',Auth::id())->latest()->get();


            return view('public.SiteFront.profile',compact('favorites','user','orders'));
        }
        return abort('403');
    }

    protected function indexInbox(){


        if(Auth::check()){
            $user = User::whereId(Auth::id())->first();


            $messages = $user->Message()->where('status',1)->latest()->get();


            return view('public.SiteFront.inbox',compact('messages','user'));
        }

        return abort('403');

    }

    public function readMessage(Request $request){
        if(Auth::check()) {
            $this->validate($request, [
                'id' => 'required|numeric|exists:ms_participants,id'
            ]);

            $msp = MsParticipant::whereId($request->id)->first();

            $msp->seen = Carbon::now();
            $msp->save();
        }
    }

    protected function personalInfo(){

        if(Auth::check()){
            $user = User::whereId(Auth::id())->first();
            $provinces = Province::all();
            return view('public.SiteFront.auth.personalInfo',compact('user','provinces'));
        }
        return abort('403');
    }

    protected function store(Request $request){

        $this->validate($request,[
            'fname' => ['required','string'],
            'lname' => ['required','string'],
            'melli_code' =>['required'],
            'tell' => ['required'],
            'urgent_phone_no' => ['required'],
            'email' => 'email|nullable',
            'state' => 'required|max:60',
            'gender' => 'required',
            'city' => 'required',
            'postal_code' => 'required',
            'address' => 'required|max:200'
        ]);
        $request = $request->all();
        $user = User::whereId(Auth::id())->first();

        $user->update([
            'fname' => $request['fname'],
            'lname' => $request['lname'],
            'melli_code' => $request['melli_code'],
            'tell' => $request['tell'],
            'urgent_phone_no' => $request['urgent_phone_no'],
            'email' => $request['email'],
            'gender' => $request['gender'],
            'state' => $request['state'],
            'city' => $request['city'],
            'postal_code' => $request['postal_code'],
            'address' => $request['address'],
        ]);
        alert()->flash('بروز رسانی شد', 'success', [
            'text' => "حساب کاربری شما با موفقیت بروز رسانی شد",
            'showConfirmButton' => false,
            'timer' => 1500
        ]);

        return redirect(route('profile.show'));
    }

    public function addToFavorites(Request $request){
        if(Auth::check()){
            $this->validate($request,[
                'id'  => 'required|numeric|min:1|exists:products,id'
            ]);

            $user = User::whereId(Auth::id())->first();

            $user->FavoriteProducts()->sync($request->id,false);

        }
    }

    public function removeFavorite(Favorite $favorite){
        if(Auth::check()){

            deleteRecord($favorite,'کالا با موفقیت از لیست علاقه مندی شما حذف شد');

            return redirect()->back();
        }

        return abort(404);
    }

}
