<?php

namespace App\Http\Controllers\SiteFront\Product;

use App\Helpers\LogActivity;
use App\Http\Controllers\Controller;
use App\Http\Requests\loginRequest;
use App\Http\Requests\ReviewRequest;
use App\Models\Cart;
use App\Models\Products;
use App\Models\ProductsTecInfo;
use App\Models\Review;
use App\Models\ReviewScore;
use App\Models\TecInfoProduct;
use App\Models\User;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Morilog\Jalali\jDate;
use Illuminate\Contracts\Cookie\Factory;
use Illuminate\Support\Facades\Cookie;

class ProductController extends Controller
{
    use ThrottlesLogins;
    protected $useActivation = true;

    protected function index($slug,Factory $cookie){


        $product = Products::where('slug',$slug)->where('status',1)->with(['Brand','Category.StuffType','productsGallery','productsColor','pdfs'])->firstOrFail();


        $reviews = Review::where('product_id',$product->id)->where('confirmed',1)->where('replay_id',null)->latest()->get();

        $closest_products = $this->closestProduct($product);

        $random_products = Products::inRandomOrder()->where('status',1)->take(8)->get();

        $products_colors = $product->productsColor()
            ->where('status',1)
            ->orderBy('priority','asc')
            ->get();

        $tecs = ProductsTecInfo::getTecs($product->category_id);


        $jDate = new jDate();

        $totalRate = Review::totalRate($product->id);

        // $pageWasRefreshed = isset($_SERVER['HTTP_CACHE_CONTROL']) && $_SERVER['HTTP_CACHE_CONTROL'] === 'max-age=0';

        // if (!$pageWasRefreshed) {
        //     $product->increment('view_count');
        //     $this->setViews($product,$cookie);
        //     LogActivity::addToProductViewLog($product);
        // }

        return view('public.SiteFront.product',compact('tecs','totalRate','jDate','reviews','product','closest_products','random_products','products_colors'));

    }


    protected function storeReview(ReviewRequest $request){

        $request = $request->all();

        $reviews = Review::where('user_id',Auth::Id())->where('product_id',$request['product_id'])->get();

        if(isset($reviews)){
            foreach ($reviews as $review){
                $review->product_score = null;
                $review->save();
            }
        }

        Review::create([
            'user_id' => Auth::Id(),
            'product_id' => $request['product_id'],
            'name' => $request['name'],
            'text' => $request['text'],
            'product_score' =>  $request['review_rate'],
        ]);

        alert()->flash('نظر شما ثبت شد', 'success', [
            'text' => "نظر پس از تایید در قسمت نظرات قرار خواهد گرفت",
            'showConfirmButton' => true,
            'confirmButtonText' => 'باشه',
        ]);
        return redirect()->back();
    }


    protected function reviewLogin(loginRequest $request){


        if ($this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }


        $mobile = $request['mobile'];
        $user = User::where("mobile" , $mobile)->first();
        if( empty( $user ) ){
            alert()->flash('خطا!', 'error', [
                'text' => 'شماره موبایل یا رمز عبور اشتباه است',
                'type' => 'error',
                'showConfirmButton' => true,
                'confirmButtonText' => 'باشه',
            ]);
            return redirect()->back();
        }

        if($user->confirmed == 1 ){
            $remember = ($request->input('rememberMe') == 'remember') ? true : false ;
            if( ! Auth::attempt(['mobile' => $request['mobile'], 'password' => $request['password'] ] , $remember ) ){

                alert()->flash('خطا!', 'error', [
                    'text' => 'شماره موبایل یا رمز عبور اشتباه است',
                    'type' => 'error',
                    'showConfirmButton' => true,
                    'confirmButtonText' => 'باشه',
                ]);
                return redirect()->back();
            } else {

                alert()->flash('خوش آمدید', 'success', [
                    'text' => "حالا نظر خود را بنویسید",
                    'showConfirmButton' => false,
                    'timer' => 2000
                ]);
                Cart::addToCartInLogin();

                $this->clearLoginAttempts( $request );
                return redirect()->back();
            }
        } else{
            alert()->flash('خطا!', 'error', ['text' => 'حساب کاربری شما فعال نگردیده است لطفا با درخواست کد فعال سازی آن را فعال کنید',
                'type' => 'error',
                'showConfirmButton' => true,
                'confirmButtonText' => 'باشه',]);
            return redirect()->back();
        }

    }


    protected function reviewPositive(Request $request){
        $rules = [
            'review_id' => 'required|integer',
        ];

        $Messages = [
            'required' => 'آی دی نظر مورد نیاز است',
            'integer' => 'آی دی نظر فقط می تواند عدد باشد'
        ];

        $this->validate($request, $rules, $Messages);

        $request = $request->all();

        $reviewUser  = Review::whereId($request['review_id'])->where('user_id',Auth::Id())->first();

        if(isset($reviewUser)){

            return 13;

        }

        $reviewScore = ReviewScore::where('review_id',$request['review_id'])->where('user_id',Auth::Id())->first();

        if(isset($reviewScore)){
            if($reviewScore->positive == 0){
                $reviewScore->update([
                    'positive' => 1,
                    'negative' => 0
                ]);
            }else{
                return 12;
            }
        }else{
            ReviewScore::create([
                'user_id' => Auth::Id(),
                'review_id'  => $request['review_id'],
                'positive' => 1
            ]);
        }

        $score = ReviewScore::where('review_id',$request['review_id'])->get();
        $points['negative2'] =  $score->sum('negative');
        $points['positive2'] =  $score->sum('positive');

        return $points;
    }

    protected function reviewNegative(Request $request){
        $rules = [
            'review_id' => 'required|integer',
        ];

        $Messages = [
            'required' => 'آی دی نظر مورد نیاز است',
            'integer' => 'آی دی نظر فقط می تواند عدد باشد'
        ];

        $this->validate($request, $rules, $Messages);

        $request = $request->all();

        $reviewUser  = Review::whereId($request['review_id'])->where('user_id',Auth::Id())->first();

        if(isset($reviewUser)){

            return 13;

        }

        $reviewScore = ReviewScore::where('review_id',$request['review_id'])->where('user_id',Auth::Id())->first();

        if(isset($reviewScore)){
            if($reviewScore->negative == 0){
                $reviewScore->update([
                    'positive' => 0,
                    'negative' => 1
                ]);
            }else{
                return 12;
            }
        }else{
            ReviewScore::create([
                'user_id' => Auth::Id(),
                'review_id'  => $request['review_id'],
                'negative' => 1
            ]);
        }

        $score = ReviewScore::where('review_id',$request['review_id'])->get();
        $points['negative2'] =  $score->sum('negative');
        $points['positive2'] =  $score->sum('positive');

        return $points;
    }


    /*
     * this method finds the closest products based on category, price and tec_info
     * if price not set it only finds closest products base on category and tec_info
     * @Params object Products::$product
     * @Params int price $price_margin @optional
     */
    protected function closestProduct($product,$price_margin = null){

        if (!is_null($price_margin)) {
            $closest_products = Products::whereBetween('base_sell_price', [$price_margin['down'], $price_margin['top']])
                ->where('category_id', $product->category_id)
                ->where('id', '!=', $product->id)
                ->activeAvailableProducts()
                ->limit(12)
                ->get();
        } else {
            $closest_products = Products::where('category_id', $product->category_id)
                ->where('id', '!=', $product->id)
                ->activeAvailableProducts()
                ->limit(12)
                ->get();
        }


        $productInfo = array();
        if(isset($product->tec_info_keyAndValues)){
            foreach ($product->tec_info_keyAndValues as $key=>$value){
                foreach($value as $ke=>$val){
                    $productInfo[$ke]= $val;
                }
            }

            $results = array();
            $productInfo_cl = array();
            $i = 0;
            foreach($closest_products as $closest_product){
                if(isset($closest_product->tec_info_keyAndValues)) {

                    foreach ($closest_product->tec_info_keyAndValues as $key => $value) {
                        foreach ($value as $ke => $val) {
                            $productInfo_cl[$ke] = $val;
                        }
                    }
                }
                $results[$closest_product->id] = array_intersect($productInfo,  $productInfo_cl);
                $i++;
            }

            $productCount = array();
            foreach ($results as $key=>$value) {

                $productCount[$key] = count($value);

            }

            arsort($productCount);

            $linkedProducts = array();
            $count = count($productCount);
            if($count > 8){
                $i = 0;
                foreach ($productCount as $key=>$value){
                    if($i < 8){
                        $linkedProducts[] = Products::whereId($key)->where('status',1)->first();
                    }
                    $i++;
                }
            }else{
                foreach ($productCount as $key=>$value){
                    $linkedProducts[] = Products::whereId($key) ->where('status',1)->first();
                }
            }
        }else{
            $linkedProducts = $closest_products;
        }

        return $linkedProducts;
    }

    /*
     * this method makes top and down margin of a given price
     * @Param int $price
     */
    protected function makeMargin($price){

        $top = 0;
        $down = 0;

        if((0.1 < $price) &&($price <= 100000) ){
            $top = 150000;
            $down = 0;
        }
        if((100000 < $price ) &&( $price <= 400000) ){
            $top = $price+50000;
            $down = $price-50000;
        }
        if((400000 < $price) &&($price <= 700000) ){
            $top = $price+100000;
            $down = $price-100000;
        }
        if((700000 < $price) &&($price <= 1000000) ){
            $top = $price+150000;
            $down = $price-150000;
        }
        if((1000000 < $price) &&($price <= 1500000) ){
            $top = $price+200000;
            $down = $price-200000;
        }
        if((1500000 < $price) &&($price <= 7000000) ){
            $top = $price+500000;
            $down = $price-500000;
        }
        if((7000000 < $price) &&($price <= 9000000) ){
            $top = $price+800000;
            $down = $price-800000;
        }
        if((9000000 < $price) &&($price <= 12000000) ){
            $top = $price+1000000;
            $down = $price-1000000;
        }
        if(12000000 < $price){
            $top = $price+1500000;
            $down = $price-1500000;
        }
        return ['top'=> $top,'down' => $down];
    }

    protected function sendLockoutResponse(Request $request)
    {
        $seconds = $this->limiter()->availableIn(
            $this->throttleKey($request)
        );

        alert()->flash('خطا!', 'error', [
            'text' => "به دلیل تلاشهای ناموفق متعدد برای ورود، از ورود شما به مدت ". $seconds ." دقیقه جلوگیری می شود.",
            'type' => 'error',
            'showConfirmButton' => true,
        ]);
        return redirect()->back();

    }

    public function username()
    {
        return 'mobile';
    }


    protected function setViews(Products $product,Factory $cookie){
        $data = array();
        $cookie_data = Cookie::get('view');

        if (isset($cookie_data)) {

            if(!is_array($cookie_data))
            {

                $cookie_data = stripslashes($cookie_data);
                $data = json_decode($cookie_data, true);

                if(count($data) >= 8){
                    $min_key =  min(array_keys($data));
                    unset($data[$min_key]);
                }

                $data[time()] = $product->id;

            }else{

                $data = $cookie_data;
            }
        } else {

            $data[time()] = $product->id;
        }

        $data = array_unique($data);

        $data2 = json_encode($data);

        $cookie->queue($cookie->make('view', $data2, 129600));

    }
}
