<?php

namespace App\Http\Controllers\SiteFront\OrderPayment;

use App\Events\inventoryCheckoutEvent;
use App\Events\ShipmentEvent;
use App\Http\Controllers\Controller;
use App\Models\Amazing;
use App\Models\PaymentAddress;
use App\Models\Cart;
use App\Models\DiscountCode;
use App\Models\Payment;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Contracts\Cookie\Factory;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Validator;
use Larabookir\Gateway\Exceptions\BankException;
use Larabookir\Gateway\Exceptions\InvalidRequestException;
use Larabookir\Gateway\Exceptions\NotFoundTransactionException;
use Larabookir\Gateway\Exceptions\PortNotFoundException;
use Larabookir\Gateway\Exceptions\RetryException;

class PurchaseController extends Controller
{
    protected function index(Request $request,Factory $cookie){

        $request = $request->all();

        if(isset($request['p'])) {
            $first_decrypt = Cart::encrypt_decrypt('decrypt', $request['p']);

            $cartId = Cart::encrypt_decrypt('decrypt', $first_decrypt);

            $cart = Cart::findCart();
                if ($cart->updateCart() == false){
                    alert()->flash('خطا!', 'error', ['text' => 'تغییراتی در صبد خرید شما صورت گرفته لطفا دوباره اقدام نمایید.',
                        'type' => 'error',
                        'showConfirmButton' => true,

                    ]);
                    return redirect(\url('/cart'));
                }

            if(isset($cart) && $cartId == $cart->id) {

                if (Auth::check()
                    && (
                        urldecode(URL::previous()) == url('/address?cart=' . $first_decrypt)
                        || urldecode(URL::previous()) == url('/purchase?p=' . $request['p'])
                    )
                ) {
                    if (isset($request['p'])) {
                        $cart = Cart::findCart();
                        if ($cartId == $cart->id) {
                            Cart::checkCart($cookie);

                            $cartRealItems = Cart::cartRealItems();

                            $shipmentCost = Event::fire(new ShipmentEvent($cart));
                            $shipmentCost = $shipmentCost[0];

                            $cartTotalCost = Cart::cartTotalPrice();

                            $total = $cartTotalCost + $shipmentCost;

                            $payment = Payment::where('cart_id', $cart->id)->first();

                            if (isset($payment)) {
                                $payable_price = $total - $payment->discount;
                                if ($payable_price < 0) {
                                    $payable_price = 0;
                                }
                                $payment->update([
                                    'cart_id'           => $cart->id,
                                    'package_price'     => $cartTotalCost,
                                    'shipment_price'    => $shipmentCost,
                                    'total'             => $total,
                                    'discount'          => $payment->discount,
                                    'payable_price'     => $payable_price,
                                ]);

                            } else {
                                $payment = Payment::create([
                                    'cart_id'           => $cart->id,
                                    'package_price'     => $cartTotalCost,
                                    'shipment_price'    => $shipmentCost,
                                    'total'             => $total,
                                    'payable_price'     => $total,
                                ]);

                            }
                            $user = User::whereId(Auth::id())->first();

                            PaymentAddress::updateOrCreate(
                                [
                                    'user_id'       => $user->id,
                                    'payment_id'    => $payment->id
                                ]
                                ,
                                [
                                    'melli_code'        => $user->melli_code,
                                    'tell'              => $user->tell,
                                    'urgent_phone_no'   => $user->urgent_phone_no,
                                    'state'             => $user->state,
                                    'city'              => $user->city,
                                    'postal_code'       => $user->postal_code,
                                    'address'           => $user->address,
                                ]);

//                            Rad kardan tayid sabad xarid

                            $cart = Cart::findCart();
                            Cart::where('id',$cart->id)->update(['confirmed' => 1]);



                            if (!$cart->isConfirmed()){

                                // alert()->flash('سبد خرید شما تایید نشده!', 'info', [
                                //     'text' => "در این فروشگاه به دلیل حساسیت اقلام قابل خرید، سبد خرید شما نیاز به تایید توسط مدیر دارد. در صورت تایید سبد خرید با پیامک به شما اطلاع رسانی خواهد شد",
                                //     'showConfirmButton' => true,
                                // ]);
                            }

                            return view('public.SiteFront.orderPayment.beforePurchase', compact('payment', 'cartRealItems', 'first_decrypt'));
                        }
                    } else {
                        return redirect()->back();
                    }
                }
            }else{
                return redirect()->back();
            }
        }else{
            return redirect()->back();
        }

        return redirect(route('cart.show'));
    }

    public function payCheck()
    {
        if (Auth::check()) {

            $cart = Cart::findCart();
            
                if ($cart->updateCart() == false){
                    alert()->flash('خطا!', 'error', ['text' => 'تغییراتی در صبد خرید شما صورت گرفته لطفا دوباره اقدام نمایید.',
                        'type' => 'error',
                        'showConfirmButton' => true,

                    ]);
                    return redirect(\url('/cart'));
                }

            if(!$cart->isConfirmed()){
                return redirect()->back();
            }
            $payment =  $cart->Payment()->where('paid',0)->first();
            $price = $payment->payable_price * 10;

            if ($price < 1000 or $price == null) {
                return redirect()->back();
            }
            try
            {
                $gateway = \Gateway::zarinpal();
                $gateway->setCallback('invoice');
                $gateway->price($price)->ready();
                $refId = $gateway->refId();
                $transID = $gateway->transactionId();

                return $gateway->redirect();

            }
            catch (BankException $e)
            {
                $e->getMessage();

                return view('public.SiteFront.orderPayment.purchaseInvoiceFail', compact(
                    'e'
                ));

            }



        } else {
            return redirect('/login');
        }
    }

    public function callBack()
    {
        try {

            $gateway = \Gateway::verify();
            $trackingCode = $gateway->trackingCode();
            $refId = $gateway->refId();
            $cardNumber = $gateway->cardNumber();
            $transID = $gateway->transactionId();

            Event::fire(new inventoryCheckoutEvent());
            $status = Cart::payCart($transID);

            if($status !== false){
                $order_tracking = $status;
                return view('public.SiteFront.orderPayment.purchaseInvoiceSuccess', compact(
                    'trackingCode','order_tracking'
                ));

            }

        }
        catch (BankException $e) {
            $e->getMessage();
        } catch (RetryException $e) {
            $e->getMessage();
        } catch (PortNotFoundException $e) {
            $e->getMessage();
        } catch (InvalidRequestException $e) {
            $e->getMessage();
        } catch (NotFoundTransactionException $e) {
            $e->getMessage();
        }

        return view('public.SiteFront.orderPayment.purchaseInvoiceFail',compact('e'));

    }

    /*---------------------------------------------
     * result codes for checking discount:
     * --------------------------------------------
     * 666 (doesn't exist) -> it means the discount code doesn't exist.
     * 111 (exist but time not valid anymore)-> time is up
     * 112 (exist but number = 0) -> number of discount finished
     * 100 (ok) -> it means the code is exist and the discount has been applied to purchase
     * 113 (discounted before) -> discount added before
     *
     *
     * ---------------------------------------------
     * discount types:
     * ---------------------------------------------
     * 1) discountType: amount
     * -> format(-0)
     * -> it means that the discount type is amount and the amount of discount is going to Subtract from price
     *
     * Usage: $totalPrice - amount
     * :::::::::::::::::::::::::
     * discount_type: 10 = (limitless amount)
     * discount_type: 20 = (amount with time limit)
     * discount_type: 30 = (amount with number limit)
     * discount_type: 40 = (amount with both number & time limit)
     *
     * -----------------/\/\/\/\/\/\/\/\/\/\/\/\/\
     * 2) discountType: percentage
     * -> format(-1)
     * -> it means that the discount type is percentage and the percentage of total price is going to Subtract from it
     *
     * Usage: $totalPrice - ( $totalPrice * percentage / 100)
     * ::::::::::::::::::::::::::
     * discount_type: 11 = (limitless percent)
     * discount_type: 21 = (percent with time limit)
     * discount_type: 31 = (percent with number limit)
     * discount_type: 41 = (percent with both number & time limit)
     *
     * code 1370 = it means discount only should apply to products that are not in amazing suggestions
     * code 1212 = it means payable price is less than discount down limit
     * code 1213 = it means payable price is higher than discount top limit
     * code 1962 = it means cart has not been approved
     */
    protected function discountCodeStore(Request $request){

        $request            = $request->all();
        $encDiscountCode    = encrypt_decrypt('encrypt',$request['discount-code']);
        $discountCode       = DiscountCode::where('code',$encDiscountCode)->first();

        $cart               = Cart::findCart();
        $payment            = Payment::where('cart_id',$cart->id)->first();
        $productColors      = Cart::cartRealItemsDB();

        if($cart->confirmed == 0){
            return json_encode(['code' => 1962]);
        }

        if(!is_null($productColors)){
            foreach ($productColors as $productColor){
                $product = $productColor->Product()->first();

                $validator = Validator::make(['product_id' => $product->id],
                    ['product_id' => 'exists:amazings,product_id']
                );

                if (!$validator->fails()){
                    $amazing = Amazing::where('product_id',$product->id)->first();

                    if(isset($amazing) && $amazing->status != 0){
                        return json_encode(['code' => 1370]);
                    }
                }
            }
        }

        //*******************amount*********************//
        if(isset($discountCode)){


            if(!is_null($discountCode->price_down)){
                if($payment->total < $discountCode->price_down){
                    return json_encode(['code' => 1212,'limit' => $discountCode->price_down]);
                }
            }

            if(!is_null($discountCode->price_top)){
                if($payment->total > $discountCode->price_top){
                    return json_encode(['code' => 1213,'limit' => $discountCode->price_down]);
                }
            }

            switch ($discountCode->discount_type){
                case 10:
                    if(is_null($payment->discount_code_id)){
                        $payable_price = $payment->total - roundDiscount($discountCode->amount);
                        if($payable_price < 0){
                            $payable_price = 0;
                        }
                        $payment->update([
                            'discount_code_id'      => $discountCode->id,
                            'discount'              => roundDiscount($discountCode->amount),
                            'payable_price'         => $payable_price
                        ]);
                    }else{
                        return json_encode(['code' => 113]);
                    }
                    break;
                case 20:
                    if(is_null($payment->discount_code_id)){
                        $time = $discountCode->valid_time;
                        $payable_price = $payment->total - roundDiscount($discountCode->amount);
                        if($payable_price<0){
                            $payable_price = 0;
                        }
                        if($time->gt(Carbon::now())){
                            $payment->update([
                                'discount_code_id'  => $discountCode->id,
                                'discount'          => roundDiscount($discountCode->amount),
                                'payable_price'     => $payable_price
                            ]);
                        }else{
                            deleteSimple($discountCode);

                            return json_encode(['code' => 111]);
                        }
                    }else{
                        return json_encode(['code' => 113]);
                    }
                    break;
                case 30:
                    if(is_null($payment->discount_code_id)){
                        $leftedNumbers = $discountCode->times_left;
                        $payable_price = $payment->total - roundDiscount($discountCode->amount);
                        if($payable_price<0){
                            $payable_price = 0;
                        }
                        if($leftedNumbers > 0){
                            $payment->update([
                                'discount_code_id'  => $discountCode->id,
                                'discount'          => roundDiscount($discountCode->amount),
                                'payable_price'     => $payable_price
                            ]);
                            $discountCode->times_left = $leftedNumbers - 1;
                            $discountCode->save();
                        }else{
                            deleteSimple($discountCode);
                            return json_encode(['code' => 112]);
                        }
                    }else{
                        return json_encode(['code' => 113]);
                    }
                    break;
                case 40:
                    if(is_null($payment->discount_code_id)){
                        $leftedNumbers = $discountCode->times_left;
                        $time = $discountCode->valid_time;
                        $payable_price = $payment->total - roundDiscount($discountCode->amount);
                        if($payable_price<0){
                            $payable_price = 0;
                        }
                        if($leftedNumbers > 0){
                            if($time->gt(Carbon::now())){
                                $payment->update([
                                    'discount_code_id'  => $discountCode->id,
                                    'discount'          => roundDiscount($discountCode->amount),
                                    'payable_price'     => $payable_price
                                ]);
                                $discountCode->times_left = $leftedNumbers - 1;
                                $discountCode->save();
                            }else{
                                deleteSimple($discountCode);
                                return json_encode(['code' => 111]);
                            }
                        }else{
                            deleteSimple($discountCode);
                            return json_encode(['code' => 112]);
                        }
                    }else{
                        return json_encode(['code' => 113]);
                    }
                    break;

                //*******************percentage*********************//
                case 11:
                    if(is_null($payment->discount_code_id)){
                        $discount = $payment->total * $discountCode->percentage / 100 ;
                        $payable_price = $payment->total - roundDiscount($discount);
                        if($payable_price < 0){
                            $payable_price = 0;
                        }
                        $payment->update([
                            'discount_code_id'  => $discountCode->id,
                            'discount'          => roundDiscount($discount),
                            'payable_price'     =>  $payable_price
                        ]);
                    }else{
                        return json_encode(['code' => 113]);
                    }
                    break;
                case 21:
                    if(is_null($payment->discount_code_id)){
                        $time = $discountCode->valid_time;

                        if($time->gt(Carbon::now())){
                            $discount = $payment->total * $discountCode->percentage / 100 ;
                            $payable_price = $payment->total - roundDiscount($discount);
                            if($payable_price < 0){
                                $payable_price = 0;
                            }
                            $payment->update([
                                'discount_code_id'  => $discountCode->id,
                                'discount'          => roundDiscount($discount),
                                'payable_price'     =>  $payable_price
                            ]);
                        }else{
                            deleteSimple($discountCode);
                            return json_encode(['code' => 111]);
                        }
                    }else{
                        return json_encode(['code' => 113]);
                    }
                    break;
                case 31:
                    if(is_null($payment->discount_code_id)){
                        $leftedNumbers = $discountCode->times_left;
                        if($leftedNumbers > 0){
                            $discount = $payment->total * $discountCode->percentage / 100 ;
                            $payable_price = $payment->total - roundDiscount($discount);
                            if($payable_price < 0){
                                $payable_price = 0;
                            }
                            $payment->update([
                                'discount_code_id'  => $discountCode->id,
                                'discount'          => roundDiscount($discount),
                                'payable_price'     =>  $payable_price
                            ]);
                            $discountCode->times_left = $leftedNumbers - 1;
                            $discountCode->save();
                        }else{
                            deleteSimple($discountCode);
                            return json_encode(['code' => 112]);
                        }
                    }else{
                        return json_encode(['code' => 113]);
                    }
                    break;
                case 41:
                    if(is_null($payment->discount_code_id)){
                        $leftedNumbers = $discountCode->times_left;
                        $time = $discountCode->valid_time;
                        if($leftedNumbers > 0){
                            if($time->gt(Carbon::now())){
                                $discount = $payment->total * $discountCode->percentage / 100 ;
                                $payable_price = $payment->total - roundDiscount($discount);
                                if($payable_price < 0){
                                    $payable_price = 0;
                                }
                                $payment->update([
                                    'discount_code_id' => $discountCode->id,
                                    'discount'         => roundDiscount($discount),
                                    'payable_price'    => $payable_price
                                ]);
                                $discountCode->times_left = $leftedNumbers - 1;
                                $discountCode->save();
                            }else{
                                deleteSimple($discountCode);
                                return json_encode(['code' => 111]);
                            }
                        }else{
                            deleteSimple($discountCode);
                            return json_encode(['code' => 112]);
                        }
                    }else{
                        return json_encode(['code' => 113]);
                    }
                    break;
            }
            return json_encode(['code' => 100]);

        }else{
            return json_encode(['code' => 666]);
        }
    }
}
