<?php

namespace App\Http\Controllers\SiteFront\OrderPayment;

use App\Events\ShipmentEvent;
use App\Http\Controllers\Controller;

use App\Models\Cart;
use App\Models\City;
use App\Models\Province;
use Illuminate\Contracts\Cookie\Factory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\URL;

class AddressController extends Controller
{
    protected function index(Request $request,Factory $cookie){

        $dualToken = Cart::encrypt_decrypt('encrypt', $request['cart']);


        if(Auth::check()
            && (
                urldecode(URL::previous()) == url('/cart')
                ||  urldecode(URL::previous()) == url('/address?cart='.$request['cart'])
                ||  urldecode(URL::previous()) == url('/address')
                ||  urldecode(URL::previous()) == url('/purchase?p='.$dualToken)
            )
        )
        {
            if(isset($request['cart'])){
                $dycCartId = Cart::encrypt_decrypt('decrypt', $request['cart']);
                $cart = Cart::findCart();
                if ($cart->updateCart() == false){
                    alert()->flash('خطا!', 'error', ['text' => 'تغییراتی در صبد خرید شما صورت گرفته لطفا دوباره اقدام نمایید.',
                        'type' => 'error',
                        'showConfirmButton' => true,

                    ]);
                    return redirect(\url('/cart'));
                }
                if($dycCartId == $cart->id){
                    Cart::checkCart($cookie);

                    $cartItems = Cart::cartRealItems();
                    $user = Auth::user();
                    if($user->completed == 1){
                        $shipmentCost = Event::fire(new ShipmentEvent($cart))[0];
                    }
                    $provinces = Province::all();

                    return view('public.SiteFront.orderPayment.address',compact('user','cartItems','provinces','shipmentCost','dualToken'));
                }
            }else{
                return redirect()->back();
            }
        }

        return view('public.SiteFront.orderPayment.registerQuestion');

    }

    protected function personalInfoShow(){

        $user = Auth::user();
        if(isset($user)){
            if($user->completed == 0){
                $provinces = Province::all();

                return view('public.SiteFront.auth.registerStep2',compact('provinces'));
            }
        }
        return redirect()->home();
    }

    protected function getCities(Request $request){
        $request = $request->all();
        if($request['province'] !== 0){
            $province = Province::where('name',$request['province'])->first();
            if(!is_null($province)){
                $cities = $province->City()->get();
            }else{
                $cities = 0;
            }
        }else{
            $cities = 0;
        }
        return $cities;
    }
}
