<?php

namespace App\Http\Controllers\SiteFront;

use App\Http\Controllers\Controller;
use App\Models\Amazing;
use App\Models\Article;
use App\Models\Baner;
use App\Models\Cart;
use App\Models\PriceList;
use App\Models\Service;
use App\Models\Slider;
use Illuminate\Support\Carbon;

class HomeController extends Controller
{
    protected function index(){

        $priceLists=PriceList::limit(10)->get();
        $articles=Article::whereStatus(1)->latest()->limit(5)->get();
        $sliders=Slider::whereStatus(true)->get();
        $banners=Baner::orWhere('type','home')->orWhere('type','social')->get();
        $amazings=Amazing::whereStatus(1)->where('start','<',Carbon::now())->where('end','>',Carbon::now())->orderBy('order','ASC')->limit(10)->get();
        return view('public.SiteFront.index',compact('banners','sliders','articles','amazings','priceLists'));
    }

}
