<?php

namespace App\Http\Controllers\SiteFront\Collections;

use App\Helpers\Choices;
use App\Helpers\LAHelper;
use App\Helpers\LogActivity;
use App\Helpers\Search;
use App\Http\Controllers\Controller;
use App\Models\ColorStore;
use App\Models\FilterTitle;
use App\Models\Products;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use TeamTNT\TNTSearch\TNTSearch;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Contracts\Cookie\Factory;

class SearchController extends Controller
{
    use Choices;
    protected function index(Request $request, Factory $cookie)
    {

        if (!$request->ajax()) {
            $pageWasRefreshed = isset($_SERVER['HTTP_CACHE_CONTROL']) && $_SERVER['HTTP_CACHE_CONTROL'] === 'max-age=0';

            if (!$pageWasRefreshed) {
                session()->forget('choices');
            }
        }


        $products = Search::doSearch($request);


        $price_range = $this->priceRange($request->input('category'));

        if ($request->ajax()) {
            return view('public.SiteFront.Collections.load', [
                'products' => $products->appends(Input::except('page')),
                'session' => session('id'),
                'request' => $request->all()
            ]);
        }

        session()->forget('id');

        $filterTitles = FilterTitle::where('category_id', $request->input('category'))
            ->where('status', 1)
            ->orderBy('priority', 'asc')
            ->get();

        $colors = ColorStore::all();

        $brands = $this->getBrands($request->input('category'));

        $viewedProducts = $this->getViews($cookie);

        return view('public.SiteFront.Collections.search_collections', [
            'products' => $products->appends(Input::except('page')),
            'session' => session('id'),
            'price_range' => $price_range,
            'filterTitles' => $filterTitles,
            'colors' => $colors,
            'brands' => $brands,
            'request' => $request->all(),
            'viewedProducts' => $viewedProducts,
            'session2' => session('choices')
        ]);

    }

    protected function searchBox(Request $request, Factory $cookie)
    {
        $request['q']=convert($request['q'],'en');

        if (!$request->ajax()) {
            $pageWasRefreshed = isset($_SERVER['HTTP_CACHE_CONTROL']) && $_SERVER['HTTP_CACHE_CONTROL'] === 'max-age=0';

            if (!$pageWasRefreshed) {
                session()->forget('choices');
            }
        }
        $tnt = new TNTSearch;

        $this->get_search_config($tnt);

        $q = $request->input('q');
        $category = $request->input('category');
        $status = $request->input('status');
        $price = $request->input('price');
        $sort = $request->input('sortby');

        $tnt->selectIndex('products.index');

        if ($category == 0) {
            $price_range = $this->priceRange();
            if (!is_null($q)) {
                $products = Products::search($q)->where('status', 1);
            } else {
                $products = Products::where('status', 1);
            }
//            LogActivity::addToSearchLog($q);
        } else {
            $price_range = $this->priceRange($category);
            if (!is_null($q)) {
                $products = Products::search($q)->where('category_id', $category)->where('status', 1);

            } else {
                $products = Products::where('category_id', $category)->where('status', 1);

            }
//            LogActivity::addToSearchLog($q,$category);
        }

        if (!is_null($sort)) {
            $products = $products->when($sort, function ($query) use ($sort) {
                switch ($sort) {
                    case 1:
                        $query = $query->orderBy('created_at', 'desc');
                        break;
                    case 2:
                        $query = $query->orderBy('view_count', 'desc');
                        break;
                    case 3:
                        $query = $query->orderBy('sold_count', 'desc');
                        break;
                    case 4:
                        $query = $query->orderBy('base_sell_price', 'asc');
                        break;
                    case 5:
                        $query = $query->orderBy('base_sell_price', 'desc');
                        break;
                }
                return $query;
            });
        } else {
            $products = $products->orderBy('created_at', 'desc');
        }


        $products = collect($products->get());

        if (!is_null($status) && $status != 0) {
            if (!$request->ajax()) {
                $this->choicesMade('status', 1);
            }
            $products = $products->filter(function ($product) {
                if ($product->checkAvailable()) {
                    return true;
                }
                return false;
            });
        }
        if (!is_null($price)) {
            if (!$request->ajax()) {
                $this->choicesMadePrice($price, $category);
            }
            $price = explode(',', $price);

            $products = $products->filter(function ($product) use ($price) {
                if (is_array($price)) {
                    if ($product->base_sell_price >= current($price)) {
                        if ($product->base_sell_price <= next($price)) {
                            return true;
                        }

                    }
                }

                return false;
            });
        }

        $products = LAHelper::paginate($products, 16, $request);


        if ($request->ajax()) {
            $session = session('id');
            return view('public.SiteFront.Collections.load', [
                'products' => $products->appends(Input::except('page')),
                'session' => $session,
                'request' => $request->all(),

            ]);
        }

        session()->forget('id');
        $viewedProducts = $this->getViews($cookie);
        return view('public.SiteFront.Collections.search_box', [
            'products' => $products->appends(Input::except('page')),
            'session' => session('id'),
            'price_range' => $price_range,
            'request' => $request->all(),
            'searchBox' => $q,
            'viewedProducts' => $viewedProducts,
            'session2' => session('choices')
        ]);

    }


    protected function priceRange($category = null)
    {
        $price_range = array();
        if (!is_null($category)) {
            if (is_array($category))
                $category = current($category);
            $min_price_base = Products::where('category_id', $category)->where('status', 1)->min('base_sell_price');
            $max_price_base = Products::where('category_id', $category)->where('status', 1)->max('base_sell_price');
            $min_price_dis = Products::where('category_id', $category)->where('status', 1)->min('discount_sell_price');
            $max_price_dis = Products::where('category_id', $category)->where('status', 1)->max('discount_sell_price');

            $price_range['min'] = ($min_price_base <=> $min_price_dis) == -1 ? $min_price_base : $min_price_dis;
            $price_range['max'] = ($max_price_base <=> $max_price_dis) == 1 ? $max_price_base : $max_price_dis;

        } else {
            $min_price_base = Products::where('status', 1)->min('base_sell_price');
            $max_price_base = Products::where('status', 1)->max('base_sell_price');
            $min_price_dis = Products::where('status', 1)->min('discount_sell_price');
            $max_price_dis = Products::where('status', 1)->max('discount_sell_price');

            $price_range['min'] = ($min_price_base <=> $min_price_dis) == -1 ? $min_price_base : $min_price_dis;
            $price_range['max'] = ($max_price_base <=> $max_price_dis) == 1 ? $max_price_base : $max_price_dis;
        }

        $minlength = strlen((string)$price_range['min']) - 1;
        $maxlength = strlen((string)$price_range['max']) - 1;
        if ($price_range['min'] == 0) {
            $price_range['min'] = 0;
        } else {
            $price_range['min'] = floor($price_range['min'] / pow(10, $minlength)) * pow(10, $minlength);
        }

        $price_range['max'] = ceil($price_range['max'] / pow(10, $maxlength)) * pow(10, $maxlength);

        return $price_range;
    }

    protected function getBrands($category)
    {
        $products = array();
        foreach ($category as $cat_id) {
            $products[] = Products::where('category_id', $cat_id)->where('status', 1)->get();
        }
        $brands = array();
        foreach ($products as $product) {
            foreach ($product as $pro) {
                $brand = $pro->Brand()->first();
                $brands[$brand->id] = $brand;
            }
        }
        $brands = array_unique($brands);
        return $brands;

    }

    protected function paginate($items, $perPage, $request)
    {

        $page = Input::get('page', 1); // Get the current page or default to 1


        $items = $items instanceof Collection ? $items : Collection::make($items);

        return new LengthAwarePaginator($items->forPage($page, $perPage), $items->count(), $perPage, $page,
            ['path' => $request->url(), 'query' => $request->query()]);
    }

    protected function set_choices_filters(Request $request)
    {
        $request = $request->all();

        $session2 = session('choices');

        if (isset($session2)) {

            if (searchArray($session2, $request['html'], (string)$request['filter'])) {
                session()->forget('choices.' . $request['html']);
            } else {
                $array = session()->get('choices', []);

                $array[$request['html']] = $request['filter'];

                session()->put('choices', $array);
            }
        } else {
            $choice[$request['html']] = $request['filter'];
            session()->put('choices', $choice);
        }
        $session2 = session('choices');

        $previous_min = $request['previous_min'];
        $previous_max = $request['previous_max'];
        return view('public.SiteFront.Collections.choices', compact('session2', 'previous_min', 'previous_max'));
    }

    protected function set_choices_status(Request $request)
    {

        $request = $request->all();

        $session2 = session('choices');

        $html = 'فقط کالاهای موجود';
        if ($request['filter'] == 1) {
            $request['filter'] = 'status=' . "1";
            if (isset($session2)) {
                if (isset($session2[$html]) && $session2[$html] == 1) {
                    session()->forget('choices.' . $html);
                } else {
                    $array = session()->get('choices', []);

                    $array[$html] = $request['filter'];

                    session()->put('choices', $array);
                }
            } else {
                $choice[$html] = $request['filter'];
                session()->put('choices', $choice);
            }
        } else {
            session()->forget('choices.' . $html);
        }

        $session2 = session('choices');

        $previous_min = $request['previous_min'];
        $previous_max = $request['previous_max'];

        return view('public.SiteFront.Collections.choices', compact('session2', 'previous_min', 'previous_max'));
    }

    protected function set_choices_price(Request $request)
    {

        $request = $request->all();

        $price = explode(',', $request['filter']);
        reset($price);

        $html = 'از ' . priceFormat(current($price)) . ' تا ' . priceFormat($price[1]) . ' تومان';
        $previous_html = 'از ' . priceFormat($request['previous_min']) . ' تا ' . priceFormat($request['previous_max']) . ' تومان';
        if (current($price) == $request['min'] && next($price) == $request['max']) {
            session()->forget('choices.' . $previous_html);
        } else {
            $session2 = session('choices');
            $filter = 'price=' . $request['filter'];
            $previous_filter = 'price=' . $request['previous_min'] . ',' . $request['previous_max'];
            if (isset($session2)) {
                if (searchArray($session2, $previous_html, (string)$previous_filter)) {
                    session()->forget('choices.' . $previous_html);
                }
                $array = session()->get('choices', []);

                $array[$html] = $filter;

                session()->put('choices', $array);

            } else {
                $choice[$html] = $filter;
                session()->put('choices', $choice);
            }
        }
        $session2 = session('choices');

        $previous_min = current($price);
        $previous_max = next($price);

        return view('public.SiteFront.Collections.choices', compact('session2', 'previous_min', 'previous_max'));
    }

    protected function set_choices_colors(Request $request)
    {

        $request = $request->all();

        $session2 = session('choices');

        if (isset($session2)) {

            if (searchArray($session2, $request['html'], (string)$request['filter'])) {
                session()->forget('choices.' . $request['html']);
            } else {
                $array = session()->get('choices', []);

                $array[$request['html']] = $request['filter'];

                session()->put('choices', $array);
            }
        } else {

            $choice[$request['html']] = $request['filter'];
            session()->put('choices', $choice);
        }

        $session2 = session('choices');
        $previous_min = $request['previous_min'];
        $previous_max = $request['previous_max'];
        return view('public.SiteFront.Collections.choices', compact('session2', 'previous_min', 'previous_max'));
    }

    protected function clear_choices()
    {

        session()->forget('choices');

        return view('public.SiteFront.Collections.choices');
    }

    protected function clear_choice(Request $request)
    {
        $request = $request->all();
        $session2 = session('choices');

        if (searchArray($session2, $request['html'], (string)$request['filter'])) {
            session()->forget('choices.' . $request['html']);
        }

        $session2 = session('choices');
        $previous_min = $request['previous_min'];
        $previous_max = $request['previous_max'];
        return view('public.SiteFront.Collections.choices', compact('session2', 'previous_min', 'previous_max'));
    }

    protected function get_search_config($tnt)
    {

        $driver = config('database.default');
        $config = config('scout.tntsearch') + config("database.connections.{$driver}");

        return $tnt->loadConfig($config);

    }

    protected function findTecInfo($tec_info, $category_id, $brand_id = null)
    {

        if (is_null($brand_id)) {
            $products = Products::where('category_id', $category_id)->where('status', 1)->latest()->get();

        } else {
            $products = Products::where('category_id', $category_id)->where('brand_id', $brand_id)->where('status', 1)->latest()->get();
        }

        $results = array();
        $productInfo = array();
        $i = 0;
        foreach ($products as $closest_product) {
            if (isset($closest_product->tec_info_keyAndValues)) {
                foreach ($closest_product->tec_info_keyAndValues as $key => $value) {
                    foreach ($value as $ke => $val) {
                        if ($val !== null) {

                            $productInfo[$ke] = $val;

                        }
                    }
                }
            }

            $results[$closest_product->id] = array_intersect($productInfo, $tec_info);
            $i++;
        }

        $results = array_filter($results);


        $linkedProducts = array();
        foreach ($results as $key => $value) {
            $linkedProducts[] = Products::whereId($key)->where('status', 1)->first();
        }

        return $linkedProducts;
    }

    protected function getViews(Factory $cookie)
    {
        $cookie_data = Cookie::get('view');

        $cookie_data = stripslashes($cookie_data);
        $data = json_decode($cookie_data, true);

        $viewedProducts = [];
        if (isset($data)) {
            foreach ($data as $index => $id) {
                $validator = Validator::make(['id' => $id], ['id' => 'exists:products,id']);

                if (!$validator->fails()) {
                    $viewedProducts[] = Products::whereId($id)->where('status', 1)->first();
                } else {
                    $key = array_search($id, $data);

                    unset($data[$key]);

                    $data = array_unique($data);

                    $data2 = json_encode($data);

                    $cookie->queue($cookie->make('view', $data2, 129600));
                }
            }
        }
        $viewedProducts = array_filter($viewedProducts, function ($value) {
            return !is_null($value);
        });
        return $viewedProducts;
    }

}
