<?php

namespace App\Http\Controllers\SiteFront\Collections;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Products;
use Illuminate\Support\Facades\View;

class CompareController extends Controller
{

    protected $base;
    protected $second;

    protected function index(Request $request){

        $tdx = $request->input('TDX');
        if(isset($tdx)){
            $tdx = array_filter($tdx);
        }
        if(!is_null($tdx)){
            foreach($tdx as $key => $val){
                $rules['TDX.'.$key] = ['integer','min:1'];
                $messages['TDX.'.$key.'.min'] = 'کد کالا 1';
                $messages['TDX.'.$key.'.integer'] = 'کد کالا 2';
            }

            $this->validate($request,$rules,$messages);

            session()->forget('id');
            $request = $request->all();

            $compares = $this->setCompers($request['TDX']);

            $products = $this->getProducts($compares);

            $brands = $this->getBrands($products);

            return view('public.SiteFront.Collections.compare_page',compact('brands','products'));
        }else{
            return redirect()->home();
        }

    }

    protected function getCompareProducts(Request $request){
        $request = $request->all();

        $products = Products::where('brand_id',$request['brand_id'])->where('status',1)->get();


        $compares = [];

        foreach ( $products as $pro){

            if($request['stuffType_id'] == $pro->stuffType_id && $request['category_id'] == $pro->category_id){
                $compares[] =  $pro;
            }

        }
        $compares = array_unique($compares);

        return $compares;
    }

    protected function getCompare($id)
    {

        $session = session('id');
        if (isset($session)) {
            if (($key = array_search($id, $session)) !== false) {

                session()->forget('id.' . $key);

            } else {
                if (count($session) < 3) {
                    session()->push('id', $id);
                } else {
                    return 'مقایسه بیش از ۳ محصول امکان پذیر نیست';
                }
            }
        } else {
            session()->push('id', $id);

        }

        $session = session('id');
        $result = array();

        $view = View::make('public.SiteFront.Collections.compare',compact('session'));

        $result[0] = $view->render();

        $result[1] = count(session('id'));
        return $result;
    }

    protected function clearCompare()
    {
        session()->forget('id');
    }

    protected function clearOneCompare($id)
    {
        $session = session('id');
        if (isset($session)) {
            if (($key = array_search($id, $session)) !== false) {

                session()->forget('id.' . $key);

            }
        }
        $session = session('id');

        $result = array();

        $view = View::make('public.SiteFront.Collections.compare',compact('session'));

        $result[0] = $view->render();

        $result[1] = count(session('id'));

        return $result;
    }

    protected function getBrands($products){
        $category = $products['products'][0]->Category()->first();

        $qs = $category->Products()->get();
        $brands = [];
        if(isset($qs)){

            foreach ($qs as $q ){
                $brands[] = $q->Brand()->first();
            }
        }
        $brands = array_unique($brands);
        return $brands;
    }

    protected function getProducts($comparedProducts){
        $products = [];

        foreach ($comparedProducts as $pro){
            $products['products'][] = $pro;
            $tecInfos = $pro->getTecInfo()->get();

            if(isset($tecInfos)){
                foreach ($tecInfos as $info){

                        $products['infos'][$info->TecInfo->tec_info_key][$pro->id] = $info->value;
                }
            }else{
                $products['infos'][][$pro->id] = '';
            }

        }

        return $products;

    }

    protected function setCompers($ids){
        $i = 1;
        $compares = [];

        foreach ( $ids as $id){
            if($i == 1){
                $this->base = Products::whereId($id)->where('status',1)->firstOrfail();
                $this->base->getTecInfo()->firstOrFail();
                $compares[] =  $this->base;
            }else{
                $this->second = Products::whereId($id)->where('status',1)->first();
                if(!empty($this->base) && !empty($this->second)){
                    $this->second->getTecInfo()->firstOrFail();

                    if($this->base->stuffType_id == $this->second->stuffType_id && $this->base->category_id == $this->second->category_id){
                        $compares[] =  $this->second;
                    }
                }

            }
            $i++;
        }
        $compares = array_unique($compares);
        return $compares;
    }
}
