<?php

namespace App\Http\Controllers\SiteFront\Collections;

use App\Helpers\LAHelper;
use App\Http\Controllers\Controller;
use App\Models\Products;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Validator;
use Illuminate\Contracts\Cookie\Factory;
class CollectionsController extends Controller
{
    protected function index(Request $request,Factory $cookie)
    {

        $products = $this->search($request);

        if ($request->ajax()) {
            return view('public.SiteFront.Collections.load', [
                'products' => $products->appends(Input::except('page')),
                'session'  => session('id'),
                'request'  => $request->all()
            ]);
        }

        session()->forget('id');

        $viewedProducts = $this->getViews($cookie);

        return view('public.SiteFront.Collections.collections', [
            'products'      => $products->appends(Input::except('page')),
            'session'       => session('id'),
            'request'       => $request->all(),
            'viewedProducts' => $viewedProducts
        ]);

    }

    protected function search($request)
    {

        $status = $request->input('status');
        $sort   = $request->input('sortby');

        $products = Products::where('status',1);

        if (!is_null($sort)) {
            $products = $products->when($sort, function ($query) use ($sort) {
                switch ($sort) {
                    case 1:
                        $query = $query->latest();
                        break;
                    case 2:
                        $query = $query->orderBy('view_count', 'desc');
                        break;
                    case 3:
                        $query = $query->orderBy('sold_count', 'desc');
                        break;
                    case 4:
                        $query = $query->orderBy('products.base_sell_price', 'asc');
                        break;
                    case 5:
                        $query = $query->orderBy('products.base_sell_price', 'desc');
                        break;
                }
                return $query;
            });
        } else {
            $products = $products->latest();
        }

        $products = collect($products->get());

        if(!is_null($status) && $status != 0){
            $products = $products->filter(function($product) {
                if($product->checkAvailable()){
                    return true;
                }
                return false;
            });
        }

        return LAHelper::paginate($products, 16, $request);

    }


    protected function getViews(Factory $cookie){
        $cookie_data = Cookie::get('view');

        $cookie_data = stripslashes($cookie_data);
        $data = json_decode($cookie_data, true);


        $viewedProducts = [];
        if(isset($data)){
            foreach ($data as $index => $id){
                $validator = Validator::make(['id'=>$id],['id'=>'exists:products,id']);

                if(!$validator->fails()){
                    $product = Products::whereId($id)->where('status',1)->first();
                    if(isset($product))
                        $viewedProducts[] = $product;
                }else{
                    $key = array_search($id,$data);

                    unset($data[$key]);

                    $data = array_unique($data);

                    $data2 = json_encode($data);

                    $cookie->queue($cookie->make('view', $data2, 129600));
                }
            }
        }
        return $viewedProducts;
    }

}
