<?php

namespace App\Http\Controllers\SiteFront\Collections;

use App\Http\Controllers\Controller;
use App\Models\Baner;
use App\Models\Category;
use App\Models\DynamicMenu;
use App\Models\DynamicSubMenu;
use App\Models\StuffType;

class CategoryController extends Controller
{
    protected function index($slug){

        $subMenu = DynamicSubMenu::where('slug',$slug)->first();

        if(isset($subMenu)){
            $category = $subMenu->category()->first();
        }else{
            $category = Category::where('slug',$slug)->first();
        }

        if(isset($category)){
            $newest = $category->Products()->where('status',1)->latest()->take(8)->skip(0)->get();

            $bestSellers = $category->Products()->where('status',1)->orderBy('sold_count','desc')->take(8)->skip(0)->get();

            $bestViews = $category->Products()->where('status',1)->orderBy('view_count','desc')->take(8)->skip(0)->get();

            $menu2 = DynamicMenu::where('status',1)->where('slug',$category->StuffType->slug)->first();

            $banner=Baner::whereCategory_id($category->id)->first();


            return view('public.SiteFront.category',compact('bestViews','bestSellers','newest','menu2','category','banner'));
        }else{
            return abort('404');
        }

    }

    protected function indexStuffType($slug){

        $dynamicMenu = DynamicMenu::where('slug',$slug)->first();

        if(isset($dynamicMenu)){
            $stuffType = $dynamicMenu->StuffType()->first();
        }else{
            $stuffType = StuffType::where('slug',$slug)->first();
        }
        if(isset($stuffType)) {
            $newest = $stuffType->Product()->where('status',1)->latest()->take(8)->skip(0)->get();

            $bestSellers = $stuffType->Product()->where('status',1)->orderBy('sold_count', 'desc')->take(8)->skip(0)->get();

            $bestViews = $stuffType->Product()->where('status',1)->orderBy('view_count', 'desc')->take(8)->skip(0)->get();

            $menu2 = DynamicMenu::where('status', 1)->where('slug', $slug)->first();

            $banner = Baner::where('stuffType_id', $stuffType->id)->first();

            return view('public.SiteFront.stuffType', compact('bestViews', 'bestSellers', 'newest', 'menu2', 'stuffType', 'banner'));
        }else{
            return abort('404');

        }
    }

}
