<?php

namespace App\Http\Controllers\SiteFront\Cart;

use App\Models\Cart;
use App\Models\Products;
use App\Models\ProductsColor;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Contracts\Cookie\Factory;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\View;

class CartController extends Controller
{
    protected function index(Factory $cookie)
    {

        Cart::checkCart($cookie);

        $totalCost = 0;
        $totalDiscount = 0;
        if(Auth::check()){

            $cartItems = Cart::cartItems();
            if(!is_null($cartItems)){
                foreach($cartItems as $item){
                    $totalCost += $item->base_sell_price * $item->qty;
                }
                $totalDiscount = $cartItems->sum('discount');
            }
        }else{
            $pageWasRefreshed = isset($_SERVER['HTTP_CACHE_CONTROL']) && $_SERVER['HTTP_CACHE_CONTROL'] === 'max-age=0';

            if (!$pageWasRefreshed) {
                header("Refresh:0");
            }

            $cartItems = Cart::cartRealItemsCookie();
            if(!is_null($cartItems)){
                foreach($cartItems as $item){
                    $totalCost += $item->base_sell_price * 1;
                    $totalDiscount += $item->discount * 1;
                    $item['cart_qty'] = 1;
                }
            }

        }
        $random_products = Products::inRandomOrder()->take(8)->get();

        $cart = Cart::findCart();

        if(!is_null($cart)){
            $token = Cart::encrypt_decrypt('encrypt', $cart->id);
        }else{
            $token = null;
        }
        return view('public.SiteFront.orderPayment.cart',compact('cartItems','random_products','totalDiscount','totalCost','token'));
    }

    protected function addToCart(Request $request,Factory $cookie){

        $status = ProductsColor::checkInventory($request['productColorId']);

        $status2 = ProductsColor::checkInventoryLimit($request['productColorId']);

        //800 error is custom error(it means we dont have that product with that color any more)
        if($status == 800){
            if(Auth::check()){
                Cart::removeFromCartDB($request['productColorId']);
            }else{
                Cart::removeFromCartCookie($request['productColorId'],$cookie);
            }
            return json_encode(['data' => 800]);
        }

        //700 error is custom error(it means the requested qty is more than our inventories amount)
        if($status2 == 700){

            return json_encode(['data' => 700]);
        }

        $request = $request->all();

        $controllerItems = array();
        if(Auth::check()){
            $cart = Cart::findCart();
            Cart::addtoCart($cart,$request['productColorId']);
            $cartItems = Cart::cartItems();

            foreach ($cartItems as $item){
                $controllerItems[] = $item->ProductColor()->first();
            }
            $mcount = $cartItems->sum('qty');

        }
        else
        {
            /*--------------------------------------------------
             *         Tozihate save kardane cookie
             *
             * -------------------------------------------------
             * be yad dashte bashid ke cookie bayad be browser ferestade shavad ta betavan an ra zakhire kard
             * vagarna nemitavan be mahze set kardan anra gereft va nemayesh dad.
             * yani be aval be browser ferestade shode va bad az set shodan mitavan ba methode digari anra gereft
             * 129600 = 2 month
             * baraye unset kardan az methode zir mishavad estefade kard:
             */
            //            unSet($_COOKIE['cart']);
            //            $res = setcookie('cart', '', time() - 3600);

            /*--------------------------------------------------
             *   Tozihate marhale be marhale in function
             *
             * -------------------------------------------------
             *1) check mikonad aya cookie vujud darad ya na
             *2) agar vojud darad aya araye ast ya na
             *3) agar araye bud anra decode karde yeki be an ezafe mikonad
             *4) agar araye nabud an ra mosavi data gharar midahad
             *5) agar ham cookie aslan vujud nadasht anra dar yek araye gharar midahad
             *6) sepas kolle item'haye tekrari araye ra hazf mikonad  : $data = array_unique($data);
             *7) bad anra dobare be jsone tabdil mikonad
             *8)va dar akhar obj cookie ra sakhte va anra da safe ejra gharar midahad. zamani ke feshar ruye serve nabud
             * cookie ra misazad
             */
            $data = array();
            $cookie_data = Cookie::get('cart');
            //1)
            if (isset($cookie_data)) {
                //2)
                if(!is_array($cookie_data))
                {
                    //3)
                    $cookie_data = stripslashes($cookie_data);
                    $data = json_decode($cookie_data, true);

                    array_push($data, $request['productColorId']);

                }else{
                    //4)
                    $data = $cookie_data;
                }
            } else {
                //5)
                $data[]   = $request['productColorId'];
            }
            //6)
            $data = array_unique($data);
            //7)
            $data2 = json_encode($data);
            //8)
            $cookie->queue($cookie->make('cart', $data2, 129600));


            foreach ($data as $id){
                $controllerItems[] = ProductsColor::whereId($id)->first();
            }
            $mcount = count($controllerItems);
        }
        $data = View::make('public.layouts.SiteFront.cart',compact('controllerItems'));

        return json_encode(['data' => $data->render(),'mcount' =>  $mcount]);

    }

    protected function addToCart2(Request $request,Factory $cookie)
    {
        $request = $request->all();

        $product = Products::whereId($request['productId'])->first();

        $product_color = $product->productsColor()->where('status',1)->orderBy('base_sell_price','asc')->first();


        $status = ProductsColor::checkInventory($product_color->id);
        $status2 = ProductsColor::checkInventoryLimit($product_color->id);


        if($status == 800){
            if(Auth::check()){
                Cart::removeFromCartDB($request['productId']);
            }else{
                Cart::removeFromCartCookie($request['productId'],$cookie);
            }
            return json_encode(['data' => 800]);
        }

        //700 error is custom error(it means the requested qty is more than our inventories amount)
        if($status2 == 700){

            return json_encode(['data' => 700]);
        }

        $controllerItems = array();
        if(Auth::check()){
            $cart = Cart::findCart();
            Cart::addtoCart($cart,$product_color->id);
            $cartItems = Cart::cartItems();

            foreach ($cartItems as $item){
                $controllerItems[] = $item->ProductColor()->first();
            }

            $mcount = $cartItems->sum('qty');
        }
        else
        {

            $data = array();
            $cookie_data = Cookie::get('cart');
            //1)
            if (isset($cookie_data)) {
                //2)
                if(!is_array($cookie_data))
                {
                    //3)
                    $cookie_data = stripslashes($cookie_data);
                    $data = json_decode($cookie_data, true);

                    array_push($data, $product_color->id);

                }else{
                    //4)
                    $data = $cookie_data;
                }
            } else {
                //5)
                $data[]   = $product_color->id;
            }
            //6)
            $data = array_unique($data);
            //7)
            $data2 = json_encode($data);
            //8)
            $cookie->queue($cookie->make('cart', $data2, 129600));


            foreach ($data as $id){
                $controllerItems[] = ProductsColor::whereId($id)->first();
            }

            $mcount = count($controllerItems);
        }

        $data = View::make('public.layouts.SiteFront.cart',compact('controllerItems'));

        return json_encode(['data' => $data->render(),'mcount' =>  $mcount]);

    }

    protected function addToCartQty(Request $request,Factory $cookie)
    {
        $request = $request->all();

        $product = Products::whereId($request['productId'])->first();

        $product_color = $product->productsColor()->where('status',1)->orderBy('base_sell_price','asc')->first();

        $status = ProductsColor::checkInventory($request['productId']);
        $status2 = ProductsColor::checkInventoryLimit($request['productId']);

        if($status == 800){
            if(Auth::check()){
                Cart::removeFromCartDB($request['productColorId']);
            }else{
                Cart::removeFromCartCookie($request['productColorId'],$cookie);
            }
            return 800;
        }

        if($status2 == 700){

            return 700;
        }

        $controllerItems = array();
        if(Auth::check()){
            $cart = Cart::findCart();
            Cart::addtoCart($cart,$product_color->id);
            $cartItems = Cart::cartItems();

            foreach ($cartItems as $item){
                $controllerItems[] = $item->ProductColor()->first();
            }

        }

        return view('public.layouts.SiteFront.cart',compact('controllerItems'));

    }


    protected function removeFromCart(Request $request,Factory $cookie){

        $request = $request->all();
        $controllerItems = array();
        if(Auth::check()) {

            Cart::removeFromCartDB($request['id']);

            $cartItems = Cart::cartItems();

            if(count($cartItems) == 0){

                deleteRecord(Cart::where('user_id',Auth::id())->where('paid',0)->first());
            }
            foreach ($cartItems as $item) {
                $controllerItems[] = $item->ProductColor()->first();
            }

            if(count(Cart::cartItems()) == 0){
                Cart::removeCart();
            }
        }else{

            $data = Cart::removeFromCartCookie($request['id'],$cookie);


            foreach ($data as $id){
                $controllerItems[] = ProductsColor::whereId($id)->first();
            }


        }
        return view('public.layouts.SiteFront.cart',compact('controllerItems'));

    }

    protected function removeFromCartPage(Request $request,Factory $cookie){

        $request = $request->all();

        if(Auth::check()) {
            Cart::removeFromCartDB($request['productColorId']);
            if(count(Cart::cartItems()) == 0){
                Cart::removeCart();
            }
        }else{
            Cart::removeFromCartCookie($request['productColorId'],$cookie);
        }

        return redirect(route('cart.show'));
    }

    protected function removeCart(Request $request){
        Cart::removeCart();
        $controllerItems = [];
        return view('public.layouts.SiteFront.cart',compact('controllerItems'));
    }

    protected function cartQty(Request $request){
        $request = $request->all();
        $totalCost = 0;
        $totalDiscount = 0;
                if ($request['qty'] < 1) {
            $request['qty']=1;
        }

        if(Auth::check()){
            $cart = Cart::findCart();
            $cartProduct = $cart->CartProduct()->whereId($request['cartProductId'])->first();

            $discount = ($cartProduct->base_sell_price - $cartProduct->discount_sell_price) * $request['qty'];

            $total = $cartProduct->base_sell_price * $request['qty'] - $discount;

            $cartProduct->update([
                'qty' => $request['qty'],
                'discount' => $discount,
                'total' => $total,
            ]);
            $cartItems = Cart::cartItems();
            $totalDiscount = $cartItems->sum('discount');
            foreach($cartItems as $item){
                $totalCost += $item->base_sell_price * $item->qty;
            }
        }

        return view('public.SiteFront.orderPayment.cartTable',compact('cartItems','totalDiscount','totalCost'));
    }

}
