<?php

namespace App\Http\Controllers\SiteFront\Article;

use App\Http\Controllers\Controller;
use App\Models\Article;
use App\Models\ArticleCategory;
use App\Models\Baner;
use App\Models\Products;
use Illuminate\Http\Request;

class ArticlesController extends Controller
{
    public function index()
    {
        $banners = Baner::whereType('article')->get();
        $articles = Article::whereStatus(1)->latest()->paginate(10);
        $visited = Article::whereStatus(1)->orderBy('view_count', 'desc')->limit(5)->get();
        $products = Products::activeAvailableProducts()->where('discount_sell_price', '!=', null)->inRandomOrder()->limit(4)->get();
        $categories = ArticleCategory::all();
        return view('public.SiteFront.Article.index', compact('banners', 'articles', 'visited', 'products', 'categories'));
    }

    public function tag($tag)
    {
        $categories = ArticleCategory::all();
        $articles = Article::
        orWhere('title', 'like', '%' . $tag . '%')
            ->orWhere('tags', 'like', '%' . $tag . '%')
            ->where('status', 1)
            ->latest()->paginate(10);
        $visited = Article::whereStatus(1)->orderBy('view_count', 'desc')->limit(5)->get();
        $products = Products::activeAvailableProducts()->where('discount_sell_price', '!=', null)->inRandomOrder()->limit(4)->get();
        $banners = Baner::whereType('article')->get();
        return view('public.SiteFront.Article.index', compact('banners', 'articles', 'visited', 'products', 'categories'));
    }

    public function search(Request $request)
    {
        $tag = $request->articleSearch;
        $categories = ArticleCategory::all();
        $articles = Article::
        orWhere('title', 'like', '%' . $tag . '%')
            ->orWhere('description', 'like', '%' . $tag . '%')
            ->orWhere('body', 'like', '%' . $tag . '%')
            ->orWhere('tags', 'like', '%' . $tag . '%')
            ->where('status', 1)
            ->latest()->paginate(10);
        $visited = Article::whereStatus(1)->orderBy('view_count', 'desc')->limit(5)->get();
        $products = Products::activeAvailableProducts()->where('discount_sell_price', '!=', null)->inRandomOrder()->limit(4)->get();
        $banners = Baner::whereType('article')->get();
        return view('public.SiteFront.Article.index', compact('banners', 'articles', 'visited', 'products', 'categories'));
    }

    public function single($slug)
    {
        $banners = Baner::whereType('article')->get();
        $article = Article::whereSlug($slug)->firstOrFail();
        $article->increment('view_count');

        $latest = Article::whereStatus(1)->latest()->limit(5)->get();
        $products = Products::activeAvailableProducts()->where('discount_sell_price', '!=', null)->inRandomOrder()->limit(4)->get();

        $next = Article::whereStatus(1)->where('id', '>', $article->id)->first();
        $previous = Article::whereStatus(1)->where('id', '<', $article->id)->first();

        return view('public.SiteFront.Article.single', compact('banners', 'article', 'latest', 'products', 'next', 'previous'));
    }

    public function categoryFilter($slug)
    {
        $category = ArticleCategory::whereSlug($slug)->first();
        $banners = Baner::whereType('article')->get();
        $articles = Article::whereStatus(1)->whereCategory_id($category->id)->latest()->paginate(10);
        $visited = Article::whereStatus(1)->orderBy('view_count', 'desc')->limit(5)->get();
        $products = Products::activeAvailableProducts()->where('discount_sell_price', '!=', null)->inRandomOrder()->limit(4)->get();
        $categories = ArticleCategory::all();
        return view('public.SiteFront.Article.index', compact('banners', 'articles', 'visited', 'products', 'categories'));

    }
}
