<?php

namespace App\Http\Controllers;


use App\Models\CartProduct;
use App\Models\GateWayTransactionLog;
use App\Models\Payment;
use App\Models\PostLog;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Morilog\Jalali\jDate;
use Morilog\Jalali\jDateTime;

class HistoryController extends Controller
{
    protected function postHistory(){

        $posts = PostLog::latest()->get();

        return view('CRM.history.post',compact('posts'));
    }

    protected function transactionHistory(){

        $transactions = GateWayTransactionLog::get();

        return view('CRM.history.transaction',compact('transactions'));
    }

    protected function sellHistory(Request $request){

        $request = $request->all();

        if(isset($request['from']) && isset($request['to'])){

            if($request['from'] > $request['to']){
                alert()->flash('خطا', 'warning', [
                    'text' => "تاریخ شروع نمی تواند از تاریخ پایان بیشتر باشد",
                    'type' => 'warning',
                    'showConfirmButton' => true,
                    'confirmButtonText' => ' باشه'
                ]);

                return redirect()->back()->withInput();
            }else{
                $from   = jDatetime::createDatetimeFromFormat('Y/m/d', convert($request['from'],'en'));
                $to     = jDatetime::createDatetimeFromFormat('Y/m/d', convert($request['to'],'en'));
                $fv = $request['from'];
                $tv = $request['to'];
            }
        }else{

            if(!isset($request['from']) && !isset($request['to'])){
                $from   = Carbon::now()->subMonth();
                $to     = Carbon::now();
            }elseif(isset($request['from']) && !isset($request['to'])){
                $from   = jDatetime::createDatetimeFromFormat('Y/m/d', convert($request['from'],'en'));
                $to     = Carbon::now();
            }elseif(!isset($request['from']) && isset($request['to'])){
                $from   = Carbon::now()->subMonth();
                $to     = jDatetime::createDatetimeFromFormat('Y/m/d', convert($request['to'],'en'));
            }

            $fv     = jDate::forge($from)->format('Y/m/d');
            $tv     = jDate::forge($to)->format('Y/m/d');

        }

        $cartProducts = CartProduct::where('sell_date','!=',null)
            ->whereBetween('sell_date',[$from, $to])
            ->orderBy('sell_date','asc')
            ->get();

        $payment = Payment::join('profits','payments.id','=','profits.payment_id')
            ->leftjoin('post_logs', 'payments.id', '=', 'post_logs.payment_id')
            ->whereBetween('profits.created_at',[$from, $to])
            ->select('payments.total',
                'payments.shipment_price',
                'payments.discount',
                'payments.payable_price',
                'profits.*',
                'post_logs.price as post_price'
            )
            ->get();

        $data['total']              = $payment->sum('total');
        $data['shipment_price']     = $payment->sum('shipment_price');
        $data['discount']           = $payment->sum('discount');
        $data['payable_price']      = $payment->sum('payable_price');
        $data['gross_profit']       = $payment->sum('gross_profit');
        $data['p_grossProfit']      = 0;
        $data['p_grossMargin']      = 0;
        $data['post_price']         = $payment->sum('post_price');

        $data['post_price_diff']    = $data['shipment_price'] - $data['post_price'];

        $count                      = $payment->sum('qty');
        $p_grossProfit              = $payment->sum('p_gross_profit');
        $p_grossMargin              = $payment->sum('p_gross_margin');


        if(isset($p_grossProfit) && $count != 0)
            $data['p_grossProfit'] = number_format($p_grossProfit / $count , 2, ".", ",");

        if(isset($p_grossMargin) && $count != 0)
            $data['p_grossMargin'] = number_format($p_grossMargin / $count , 2, ".", ",");


        $data['net_profit']         = $data['gross_profit'] - $data['post_price_diff'];

        return view('CRM.history.sell',$data)->with([
            'from'          => $fv,
            'to'            => $tv,
            'cartProducts'  => $cartProducts
        ]);
    }
}
