<?php

namespace App\Http\Controllers\Dashboard;

use App\Events\CartSmsEvent;
use App\Http\Controllers\Controller;
use App\Http\Requests\ProfileRequest;
use App\Models\Cart;
use App\Models\CartProduct;
use App\Models\Payment;
use App\Models\PostLog;
use App\Models\Products;
use App\Models\Profit;
use App\Models\Review;
use App\Models\User;
use App\Http\Requests\PasswordResetRequest;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Event;
use Morilog\Jalali\jDate;


class dashboardController extends Controller
{



    public function index(){

        $inventoryQty = Products::all()->sum('qty');;

//------------comments----------\\
        $comments = Review::where('confirmed',0)->where('replay_id',null)->latest()->take(15)->skip(0)->get();
        $confirmed_reviews = Review::where('confirmed',1)->where('replay_id',null)->latest()->take(15)->skip(0)->get();
        $declined_reviews = Review::where('confirmed',2)->where('replay_id',null)->latest()->take(15)->skip(0)->get();

        $jDate = new jDate();

        //------------orders----------\\
        $orders = new Payment();

        $profits = Profit::all();
        $payments = Payment::where('paid',1)->get();
        //------------post----------\\
        $post = PostLog::where('type',0)->sum('price');
        $peyk = PostLog::where('type',1)->sum('price');

        $pendingCarts = Cart::getUnConfirmedCarts();

        $confirmedCarts = Cart::whereConfirmed(1)->latest()->take(15)->skip(0)->get();

        $lastSells = $this->getLastSells();

        return view('CRM.Dashboard',compact(
            'pendingCarts','confirmedCarts','lastSells',
            'post','peyk','orders','payments','profits','newOrders',
            'jDate','inventoryQty','comments',
            'confirmed_reviews','declined_reviews'));
    }

    protected function profile(){


        $user = User::whereId(Auth::id())->first();


        return view('CRM.Admin.users.profile',compact('user'));
    }

    protected function storeProfile(ProfileRequest $request){
        $request = $request->all();

        $user = User::find(Auth::id());
        $user->userName = $request['userName'];
        $user->email = $request['email'];
        $user->save();
        return redirect(route('profile' , $request['userId'] ));
    }

    protected function profilePassReset(PasswordResetRequest $request){

        $request = $request->all();

        $user = User::whereId(Auth::id())->first();


        $pass_comparison =  password_verify($request['old_password'],$user->password);

        if($pass_comparison == true){
            $user->password = bcrypt($request['old_password']);
            $user->save();
            $message = "رمز عبور با موفقیت تغییر یافت";
            $messageType = "success";
            session()->flash('message',$message);
            session()->flash('messageType',$messageType);
            return redirect(route('profile' , $request['userId'] ));
        }else{
            $message = "رمز عبور قبلی که وارد کرده اید اشتباه است";
            $messageType = "failure";
            session()->flash('message',$message);
            session()->flash('messageType',$messageType);
            return redirect(route('profile' , $request['userId'] ));
        }
    }

    protected function changeComment(Request $request){

        $request =$request->all();


        Review::whereId($request['id'])->update([
            'confirmed' => $request['status']
        ]);

        $comments = Review::where('confirmed',0)->latest()->take(15)->skip(0)->get();
        $confirmed_reviews = Review::where('confirmed',1)->latest()->take(15)->skip(0)->get();
        $declined_reviews = Review::where('confirmed',2)->latest()->take(15)->skip(0)->get();


        return view('CRM.dashboardIncludes.comments',compact('comments','confirmed_reviews','declined_reviews','jDate'));
    }

    protected function changeCart(Request $request){

        $request = $request->all();

        $cart = Cart::whereId($request['id'])->first();
        $cart->update([
            'confirmed' => $request['status']
        ]);

        if($request['status'] == 1){
            Event::fire(new CartSmsEvent($cart));
        }

        $pendingCarts = Cart::getUnConfirmedCarts();
        $confirmedCarts = Cart::whereConfirmed(1)->latest('updated_at')->take(15)->skip(0)->get();


        return view('CRM.dashboardIncludes.confirmCart',compact('pendingCarts','confirmedCarts'));
    }

    protected function deleteComment(Request $request){
        $request = $request->all();

        deleteRecord(Review::whereId($request['id'])->first());

        $comments = Review::where('confirmed',0)->latest()->take(15)->skip(0)->get();
        $confirmed_reviews = Review::where('confirmed',1)->latest()->take(15)->skip(0)->get();
        $declined_reviews = Review::where('confirmed',2)->latest()->take(15)->skip(0)->get();

        $jDate = new jDate();

        return view('CRM.dashboardIncludes.comments',compact('comments','confirmed_reviews','declined_reviews','jDate'));

    }

    protected function getLastSells(){

      return CartProduct::where('sell_date','!=',null)->orderBy('sell_date','desc')->skip(0)->take(20)->get();


    }
}
