<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Cart;
use App\Models\CartProduct;
use App\Models\Payment;
use App\Models\Products;
use App\Models\ProductView;
use App\Models\SearchLog;
use App\Models\SearchStatistic;
use Carbon\Carbon;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;

class ChartController extends Controller
{
    protected $month = 12;
    protected $year = 6;

    public function index(){


        $search_count           = $this->getSearchCount();
        $search_logs            = $this->getSearchStatistics();
        $sold_count_perMonth    = $this->getSoldCountPerMonth();
        $sold_count_perYear     = $this->getSoldCountPerYear();
        $view_count_perMonth    = $this->getViewCountPerMonth();
        $view_count_perYear     = $this->getViewCountPerYear();

        $months                 = json_encode($this->getLastMonths($this->month));
        $years                  = json_encode($this->getLastYears($this->year));


        return view('CRM.charts.charts',compact('years','months','search_logs','search_count',
            'sold_count_perMonth','sold_count_perYear','view_count_perMonth','view_count_perYear'));
    }

    protected function indexProductsDetails(){
        $records = Products::latest()->get();
        return view('CRM.charts.details.products',compact('records'));
    }

    protected function indexSearchDetails(){
        $records = SearchLog::latest()->get();
        return view('CRM.charts.details.search',compact('records'));
    }

    protected function indexSearchDetailsCount(){
        $records = SearchStatistic::latest()->get();
        return view('CRM.charts.details.search-count',compact('records'));
    }

    //search-chart
    protected function getSearchCount(){
        $statistics = SearchStatistic::orderBy('count','desc')->skip(0)->take(20)->get();

        $search_data = [];
        $i = 0;
        foreach ($statistics as $statistic){
            if($i == 0){
                array_push($search_data,[$statistic->query,$statistic->count,true,true]);
            }else{
                array_push($search_data,[$statistic->query,$statistic->count,false,false]);
            }

            $i++;
        }

        return $search_data = json_encode($search_data);
    }

    protected function getSearchStatistics(){

        $statics =  SearchStatistic::orderBy('count','desc')->skip(0)->take(20)->get();

        $logs = array();
        $y = 0;

        foreach ($statics as $static){
            $logs[$y] = ['name' => $static->query ];
            for ($i=0; $i <= $this->month-1; $i++) {
                $sts =  SearchLog::where('created_at' , '>' , Carbon::now()->subYear())->where('query',$static->query)->whereMonth('created_at','=', Carbon::now()->subMonths($i)->month)->get();

                $logs[$y]['data'][] = count($sts);
            }
            $y++ ;
        }


        $search_logs['data'] = json_encode($logs);

        return $search_logs;
    }

    //sell-chart
    protected function getSoldCountPerMonth(){


        $cartProducts = CartProduct::groupBy('product_color_id')
            ->orderByRaw('COUNT(*) DESC')
            ->limit(20)
            ->get();

        $cartProducts = $cartProducts->filter(function($product) {
            if($product->Cart->paid == 1){
                return true;
            }
            return false;
        });


        $logs = array();
        $y = 0;

        foreach ($cartProducts as $cartProduct){
            $product = $cartProduct->ProductColor->Product()->first();
            $logs[$y] = ['name' => $product->name ];
            for ($i=0; $i<=$this->month-1; $i++) {

                $sts = CartProduct::where('created_at' , '>' , Carbon::now()->subYear())->where('product_color_id',$cartProduct->product_color_id)->whereMonth('created_at','=',Carbon::now()->subMonths($i)->month)->get();

                $logs[$y]['data'][] = count($sts);
            }
            $y++ ;
        }


        $search_logs['data'] = json_encode($logs);

        return $search_logs;
    }

    protected function getSoldCountPerYear(){


        $cartProducts = CartProduct::groupBy('product_color_id')
            ->orderByRaw('COUNT(*) DESC')
            ->limit(20)
            ->get();

        $cartProducts = $cartProducts->filter(function($product) {
            if($product->Cart->paid == 1){
                return true;
            }
            return false;
        });


        $logs = array();
        $y = 0;
        $query = CartProduct::where('created_at' , '>' , Carbon::now()->subYear($this->year));

        foreach ($cartProducts as $cartProduct){
            $product = $cartProduct->ProductColor->Product()->first();
            $logs[$y] = ['name' => $product->name ];
            for ($i=0; $i <= $this->year-1; $i++) {

                $sts = $query->where('product_color_id',$cartProduct->product_color_id)->whereYear('created_at','=' ,Carbon::now()->subYears($i)->year)->get();


                $logs[$y]['data'][] = count($sts);
            }
            $y++ ;
        }

        $search_logs['data'] = json_encode($logs);

        return $search_logs;
    }

    //view-chart
    protected function getViewCountPerMonth(){

        $products = Products::orderBy('view_count','desc')->skip(0)->take(20)->get();

        $logs = array();
        $y = 0;

        foreach ($products as $product){
            $logs[$y] = ['name' => $product->name ];
            for ($i=0; $i <= $this->month-1; $i++) {

                $sts = ProductView::where('created_at' , '>' , Carbon::now()->subYear())->where('product_id',$product->id)->whereMonth('created_at','=',Carbon::now()->subMonths($i)->month)->get();

                $logs[$y]['data'][] = count($sts);
            }
            $y++ ;
        }


        $search_logs['data'] = json_encode($logs);

        return $search_logs;
    }

    protected function getViewCountPerYear(){


        $products = Products::orderBy('view_count','desc')->skip(0)->take(20)->get();

        $logs = array();
        $y = 0;

        foreach ($products as $product){

            $logs[$y] = ['name' => $product->name ];
            for ($i=0; $i <= $this->year-1; $i++) {

                $sts = ProductView::where('created_at' , '>' , Carbon::now()->subYear($this->year))->where('product_id',$product->id)->whereYear('created_at','=' ,Carbon::now()->subYears($i)->year)->get();

                $logs[$y]['data'][] = count($sts);
            }
            $y++ ;
        }

        $search_logs['data'] = json_encode($logs);

        return $search_logs;
    }

    //methods
    protected function getLastMonths($month)
    {
        $labels = array();
        for ($i = 0 ; $i < $month ; $i++) {
            $labels[] = jdate( Carbon::now()->subMonths($i))->format('%B');
        }

        return $labels;
    }

    protected function getLastYears($year)
    {
        $labels = array();
        for ($i = 0 ; $i < $year ; $i++) {
            $labels[] = jdate( Carbon::now()->subYears($i))->format('%Y');
        }

        return $labels;
    }


}
