<?php

namespace App\Http\Controllers\CrmSiteFront\slider;

use App\Http\Requests\SliderRequest;
use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use App\Http\Controllers\Controller;
use Intervention\Image\ImageManagerStatic as Image;

class SliderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $sliders=Slider::orderBy('order')->get();
        return view('CRM.SiteFront.slider.index',compact('sliders'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(SliderRequest $request)
    {

        $image = $request->file('image');
        $path = $this->uploadImages($image, 900, 400);
        if ($request->status){
            $status=$request->status;
        }else{
            $status=0;
        }

        Slider::create([
            'type'=>$request->type,
            'name'=>$request->name,
            'title'=>$request->title,
            'body'=>$request->body,
            'url'=>$request->url,
            'order'=>$request->order,
            'status'=>$status,
            'image_path'=>$path,
        ]);

        alert()->flash('ثبت شد!', 'success', [
            'text' => "اسلاید جدید با موفقیت ثبت شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return redirect()->back();


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $slide=Slider::find($id);
        return view('CRM.SiteFront.slider.edite',compact('slide'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(SliderRequest $request,$id)
    {
        $slider=Slider::find($id);
        $image = $request->file('image');
        if ($request->status){
            $status=$request->status;
        }else{
            $status=0;
        }

        if (isset($image)) {
            if ($slider) {
                \File::delete(public_path() . $slider->image_path);
            }
            $path = $this->uploadImages($image, 900, 400);

        } else {
            $path = $slider->image_path;
        }
        $slider->update([
            'type'=>$request->type,
            'name'=>$request->name,
            'title'=>$request->title,
            'body'=>$request->body,
            'url'=>$request->url,
            'order'=>$request->order,
            'status'=>$status,
            'image_path'=>$path,
        ]);
        alert()->flash('ویرایش شد!', 'success', [
            'text' => "اسلاید مورد نظر با موفقیت ویرایش شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return redirect(route('slider-home.index'));


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $slide = Slider::find($id);

        deleteRecord($slide);

        return back();
    }

    public function status_chenge($id){
        $slide = Slider::find($id);
        if ($slide->status==1){
            $slide->update(['status'=>0]);

            alert()->flash('انجام شد!', 'success', [
                'text' => "اسلاید مورد نظر غیر فعال شد.",
                'type' => 'success',
                'timer' => 1400,

            ]);

        }else{
            $slide->update(['status'=>1]);
            alert()->flash('انجام شد!', 'success', [
                'text' => "اسلاید مورد نظر فعال شد.",
                'type' => 'success',
                'timer' => 1400,

            ]);
        }

        return back();

    }


    protected function uploadImages($file, $width, $height)

    {
        $imagePath = '/app/public/sliders/';

//        File::exists(storage_path($imagePath)) or File::makeDirectory(storage_path($imagePath));


//-------------------big-----------------\

        $fileName1 = rand(0,999)."_".time().'.'.$file->getClientOriginalExtension();


        $resize_filePath = storage_path('/app/public/sliders/' . $fileName1);

        $resize_dirPath = 'app/sliders';
        $file->move($resize_dirPath,$fileName1);
//        $this->resizeImage($file, $resize_dirPath, $resize_filePath, $width, $height);
        $public_path = '/app/sliders/' . $fileName1;
        return $public_path;
    }

    protected static function resizeImage($file, $resize_dirPath, $resize_filePath, $width, $height)
    {
//        File::exists(storage_path($resize_dirPath)) or File::makeDirectory(storage_path($resize_dirPath));
// open an image file
        $img = Image::make($file->getRealPath())->encode('jpg',75);

// now you are able to resize the instance
        $img->resize($width, $height);

//save image to resize_filePath
        $img->save($resize_filePath);

    }

}
