<?php

namespace App\Http\Controllers\CrmSiteFront\settings;

use App\Models\SocialMedia;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;


class SocialMediaController extends Controller
{
    public function index()
    {
        $socials = SocialMedia::all();
        return view('CRM.SiteFront.social.index', compact('socials'));
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'url' => 'required',
            'name' => 'required',
        ]);
        if ($validator->fails()) {
            return back()
                ->withErrors($validator)
                ->withInput();
        }

        SocialMedia::create($request->all());

        alert()->flash('انجام شد!', 'success', [
            'text' => "با موفقیت ثبت شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return back();
    }

    public function edit($id)
    {
        $social = SocialMedia::find($id);
        return view('CRM.SiteFront.social.edit', compact('social'));

    }
    public function update(Request $request, $id)
    {

        $validator = Validator::make($request->all(), [
            'url' => 'required',
            'name' => 'required',
        ]);
        if ($validator->fails()) {
            return back()
                ->withErrors($validator)
                ->withInput();
        }
        SocialMedia::find($id)->update($request->all());


        alert()->flash('ویرایش شد!', 'success', [
            'text' => " با موفقیت ویرایش شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return redirect(route('socials.index'));
    }



    public function destroy($id)
    {
        $social = SocialMedia::find($id);

        deleteRecord($social);

        return back();
    }

}
