<?php

namespace App\Http\Controllers\CrmSiteFront\settings;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use Validator;


class SettingController extends Controller
{
    public function index()
    {
        $mainSetting = Setting::first();

        return view('CRM.SiteFront.settings.edit', compact('mainSetting'));
    }

    public function update(Request $request,$id)
    {
        $setting = Setting::find($id);

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'title' => 'required',
            'description' => 'required',
            'keywords' => 'required',
            'logo' => 'mimes:jpeg,bmp,png|max:1000',
            'fave_logo' => 'mimes:jpeg,bmp,png|max:500',

            'logo_width' => 'required|integer',
            'logo_heigt' => 'required|integer',
            'fave_width' => 'required|integer',
            'fave_heigt' => 'required|integer',
        ]);
        if ($validator->fails()) {
            return back()
                ->withErrors($validator)
                ->withInput();
        }
        $logo = $request->file('logo');
        $fave = $request->file('fave_logo');
//        if (isset($logo) and isset($fave)) {
//            if ($setting) {
//                \File::delete(public_path() . $setting->logo);
//                \File::delete(public_path() . $setting->$fave);
//            }
//
//            $logo_path = $this->uploadImages($request->file('logo'), $request->logo_width, $request->logo_heigt);
//            $logo_fave = $this->uploadImages($request->file('fave_logo'), $request->fave_width, $request->fave_heigt);
//
//        } else {
//            $logo_path = $setting->logo;
//            $logo_fave = $setting->fave_logo;
//        }
        if (isset($logo)){
            if ($setting) {
                \File::delete(public_path() . $setting->logo);
            }
            $logo_path = $this->uploadImages($request->file('logo'), $request->logo_width, $request->logo_heigt);
        }else{
            $logo_path = $setting->logo;
        }

        if (isset($fave)){
            if ($setting) {
                \File::delete(public_path() . $setting->$fave);
            }
            $logo_fave = $this->uploadImages($request->file('fave_logo'), $request->fave_width, $request->fave_heigt);
        }else{
            $logo_fave = $setting->fave_logo;
        }


            Setting::updateOrCreate(['id' => $id],
                [
                    'name' => $request->name,
                    'title' => $request->title,
                    'description' => $request->description,
                    'keywords' => "$request->keywords",
                    'logo' => $logo_path,
                    'fave_logo' => $logo_fave,
                ]
            );



        alert()->flash('انجام شد!', 'success', [
            'text' => "با موفقیت ویرایش شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return back();
    }

    protected function uploadImages($file, $width, $height)

    {
        $imagePath = '/app/settings/';

        File::exists(public_path($imagePath)) or File::makeDirectory(public_path($imagePath));


//-------------------big-----------------\

        $fileName1 = rand(0,999)."_".time().'.'.$file->getClientOriginalExtension();


        $resize_filePath = public_path('/app/settings/' . $fileName1);

        $resize_dirPath = '/app/settings';
//        $file->move(public_path('/app/public/settings/'),$fileName1);
        $this->resizeImage($file, $resize_dirPath, $resize_filePath, $width, $height);
        $public_path = '/app/settings/' . $fileName1;
        return $public_path;
    }

    protected static function resizeImage($file, $resize_dirPath, $resize_filePath, $width, $height)
    {
        File::exists(public_path($resize_dirPath)) or File::makeDirectory(public_path($resize_dirPath));
// open an image file
        $img = Image::make($file->getRealPath())->encode('png',75);

// now you are able to resize the instance
        $img->resize($width, $height);

//save image to resize_filePath
        $img->save($resize_filePath);

    }


}
