<?php

namespace App\Http\Controllers\CrmSiteFront\settings;

use App\Models\Link;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;


class LinksController extends Controller
{
    public function index()
    {
        $links = Link::all();
        return view('CRM.SiteFront.links.index', compact('links'));
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'url' => 'required',
            'title' => 'required',
        ]);
        if ($validator->fails()) {
            return back()
                ->withErrors($validator)
                ->withInput();
        }

        Link::create($request->all());

        alert()->flash('انجام شد!', 'success', [
            'text' => "با موفقیت ثبت شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return back();
    }

    public function edit($id)
    {
        $link = Link::find($id);
        return view('CRM.SiteFront.links.edit', compact('link'));

    }
    public function update(Request $request, $id)
    {

        $validator = Validator::make($request->all(), [
            'url' => 'required',
            'title' => 'required',
        ]);
        if ($validator->fails()) {
            return back()
                ->withErrors($validator)
                ->withInput();
        }
        Link::find($id)->update($request->all());


        alert()->flash('ویرایش شد!', 'success', [
            'text' => " با موفقیت ویرایش شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return redirect(route('links.index'));
    }



    public function destroy($id)
    {
        $link = Link::find($id);

        deleteRecord($link);

        return back();
    }
}
