<?php

namespace App\Http\Controllers\CrmSiteFront\service;


use App\Http\Requests\ArticleRequest;
use App\Http\Requests\ServiceRequest;
use App\Models\Article;
use App\Models\Service;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

class ServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $services = Service::all();
        return view('CRM.SiteFront.service.index', compact('services'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('CRM.SiteFront.articles.create');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(ServiceRequest $request)
    {

        $image = $request->file('image');
        $path = $this->uploadImages($image, $request->width, $request->heigt);

        $services = Service::count();
        if ($services < 6) {
            Service::create([
                'title'=>$request->title,
                'url'=>$request->url,
                'order'=>$request->order,
                'image_path'=>$path,
            ]);
            alert()->flash('ثبت شد!', 'success', [
                'text' => " با موفقیت ثبت شد.",
                'timer' => 1200,

            ]);
        } else {
            alert()->flash('خطا!', 'warning', [
                'text' => "بیشتر از (4) مورد نمی توانید ثبت کنید.",
                'timer' => 3000,

            ]);

        }
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $service=Service::find($id);
        return view('CRM.SiteFront.service.edit',compact('service'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(ServiceRequest $request, $id)
    {
        $service=Service::find($id);
        $image = $request->file('image');


        if (isset($image)) {
            if ($service) {
                \File::delete(public_path() . $service->image_path);
            }
            $path = $this->uploadImages($request->file('image'), $request->width, $request->heigt);

        } else {
            $path = $service->image_path;
        }
        $service->update([
            'title'=>$request->title,
            'url'=>$request->url,
            'order'=>$request->order,
            'image_path'=>$path,
        ]);
        alert()->flash('ویرایش شد!', 'success', [
            'text' => "با موفقیت ویرایش شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return redirect(route('service.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $service=Service::find($id);
        \File::delete(public_path() . $service->image_path);

        deleteRecord($service);

        return back();
    }

    protected function uploadImages($file, $width, $height)

    {
        $imagePath = '/app/service/';

//        File::exists(storage_path($imagePath)) or File::makeDirectory(storage_path($imagePath));


//-------------------big-----------------\

        $fileName1 = time() . rand(10, 50) . "_" . $file->getClientOriginalName();


        $resize_filePath = storage_path('/app/public/service/' . $fileName1);

        $resize_dirPath = 'app/service/';

        $file->move($resize_dirPath,$fileName1);
//        $this->resizeImage($file, $resize_dirPath, $resize_filePath, $width, $height);
        $public_path = '/app/service/' . $fileName1;
        return $public_path;
    }

    protected static function resizeImage($file, $resize_dirPath, $resize_filePath, $width, $height)
    {
//        File::exists(storage_path($resize_dirPath)) or File::makeDirectory(storage_path($resize_dirPath));
// open an image file
        $img = Image::make($file->getRealPath())->encode('jpg',75);

// now you are able to resize the instance
        $img->resize($width, $height);

//save image to resize_filePath
        $img->save($resize_filePath);

    }

}
