<?php

namespace App\Http\Controllers\CrmSiteFront\priceList;


use App\Http\Requests\ArticleRequest;
use App\Http\Requests\PriceListRequest;
use App\Models\Article;
use App\Models\PriceList;
use App\Models\Products;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

class PriceListController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = Products::all();
        $priceLists = PriceList::all();
        return view('CRM.SiteFront.priceList.index', compact('priceLists', 'products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('CRM.SiteFront.articles.create');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(PriceListRequest $request)
    {
        $PriceList = PriceList::count();
        if ($PriceList < 10) {
            PriceList::create($request->all());

            alert()->flash('ثبت شد!', 'success', [
                'text' => " با موفقیت ثبت شد.",
                'timer' => 1200,

            ]);
        } else {
            alert()->flash('خطا!', 'warning', [
                'text' => "بیشتر از (10) محصول نمی توانید ثبت کنید.",
                'timer' => 3000,

            ]);

        }

        return redirect(route('priceList.index'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $priceList = PriceList::find($id);
        $products = Products::all();
        return view('CRM.SiteFront.priceList.edit', compact('priceList','products'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(PriceListRequest $request, $id)
    {
        $priceList = PriceList::find($id);

        $priceList->update($request->all());

        alert()->flash('ویرایش شد!', 'success', [
            'text' => " با موفقیت ویرایش شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return redirect(route('priceList.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $priceList = PriceList::find($id);

        deleteRecord($priceList);

        return back();
    }

}
