<?php

namespace App\Http\Controllers\CrmSiteFront\orders;

use App\Events\PurchaseSendByPeykEvent;
use App\Events\PurchaseSendByPostEvent;
use App\Http\Controllers\Controller;

use App\Listeners\PurchasePostSms;
use App\Models\Payment;

use App\Models\PostLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Event;
use Morilog\Jalali\jDate;

class OrdersController extends Controller
{

    protected function index(){

                $orders = Payment::latest()->with(['Transaction'])->get();


        $jdate = new jDate();



        return view('CRM.SiteFront.orders.all',compact('orders','jdate'));
    }

    protected function sectionIndex(){

        return view('CRM.SiteFront.orders.section');
    }

    protected function modeIndex($mode){
        if($mode == 1){
            if(!Auth::user()->can(['مدیریت سفارشات','همه','سفارشات در انتظار تایید'])){
                return abort('403');
            }
        }elseif($mode == 2){
            if(!Auth::user()->can(['مدیریت سفارشات','همه','سفارشات در حال بررسی'])){
                return abort('403');
            }
        }elseif($mode == 3){
            if(!Auth::user()->can(['مدیریت سفارشات','همه','سفارشات در انتظار ارسال'])){
                return abort('403');
            }
        }elseif($mode == 4){
            if(!Auth::user()->can(['مدیریت سفارشات','همه','سفارشات ارسال شده'])){
                return abort('403');
            }
        }elseif($mode == 5){
            if(!Auth::user()->can(['مدیریت سفارشات','همه','سفارشات تحویل داده شده'])){
                return abort('403');
            }
        }else{
            return abort('403');
        }
        $orders = Payment::where('status',$mode)->latest()->get();

        $jdate = new jDate();

        return view('CRM.SiteFront.orders.mode',compact('orders','mode','jdate'));
    }

    protected function viewOrder(Request $request){

        if($request->ajax()){
            $request = $request->all();

            $order = Payment::whereId($request['id'])->first();
            $mode = $request['mode'];
            return view('CRM.SiteFront.orders.viewModalInclude',compact('mode','order'));
        }else{
            return abort(403);
        }

    }

    protected function viewOrderHistory(Request $request){
        if($request->ajax()){
            $request = $request->all();

            $order = Payment::whereId($request['id'])->first();
            $mode = $request['mode'];

            return view('CRM.history.viewModalInclude',compact('mode','order'));
        }else{
            return abort(403);
        }
    }

    protected function changeStatus(Request $request){

        $request = $request->all();

        $jdate = new jDate();

        Payment::whereId($request['id'])->update([
            'status' => $request['mode']+1
        ]);
        $mode = $request['mode'];


        if (!isset($request['status'])) {

            $orders = Payment::where('status', $request['mode'])->latest()->get();

            return view('CRM.SiteFront.orders.tableInclude', compact('mode', 'orders', 'jdate'));
        } else {
            $orders = Payment::latest()->get();

            return view('CRM.SiteFront.orders.allTableInclude', compact('mode', 'orders', 'jdate'));
        }

    }

    protected function postCodeStore(Request $request){

        $this->validate($request,[
            'order_id' => 'required|integer',
            'post_code' => 'required',
            'post_cost' => 'required|integer'
        ]);
        $request = $request->all();

        $post = PostLog::create([
            'payment_id' => $request['order_id'],
            'type'       => 0,
            'post_code'  => $request['post_code'],
            'price'      => $request['post_cost']
        ]);

        $payment = Payment::whereId($request['order_id'])->first();

        $payment->update([
            'status' => 4
        ]);

        Event::fire(new PurchaseSendByPostEvent($payment,$post));

        alert()->flash('انتقال یافت', 'success', [
            'text' => "سفارش با موفقیت تایید و مرحله بعد انتفال یافت",
            'timer' => 1500
        ]);

        return redirect(route('orders.mode',3));
    }

    protected function peykStore(Request $request){

        $this->validate($request,[
            'order_id_peyk' => 'required|integer',
            'peyk_cost' => 'required|integer'
        ]);
        $request = $request->all();

        PostLog::create([
            'payment_id' => $request['order_id_peyk'],
            'type'       => 1,
            'price'      => $request['peyk_cost']
        ]);

        $payment = Payment::whereId($request['order_id_peyk'])->first();

        $payment->update([
            'status' => 4
        ]);

        Event::fire(new PurchaseSendByPeykEvent($payment));

        alert()->flash('انتقال یافت', 'success', [
            'text' => "سفارش با موفقیت تایید و مرحله بعد انتفال یافت",
            'timer' => 1500
        ]);

        return redirect(route('orders.mode',3));
    }

}
