<?php

namespace App\Http\Controllers\CrmSiteFront\message;

use App\Http\Controllers\Controller;
use App\Models\Accessory;
use App\Models\Baner;
use App\Models\Category;
use App\Models\BestSeller;
use App\Models\MsMessage;
use App\Models\MsParticipant;
use App\Models\User;
use Illuminate\Http\Request;
class MessagesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $messages = MsMessage::latest()->get();

        return view('CRM.SiteFront.messages.all',compact('messages'));
    }

    public function usersIndex(MsMessage $msMessage){

        $users = $msMessage->User()->get();
        $users2 = User::orderBy('role','asc')->get();

        return view('CRM.SiteFront.messages.users')->with([
            'message' => $msMessage,
            'users'   => $users,
            'users2'  => $users2
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $users = User::orderBy('role','asc')->get();

        return view('CRM.SiteFront.messages.create',compact('users'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request,[
            'subject'    => 'required|string|max:255',
            'message'    => 'required|string|max:60000',
            'status'     => 'required|boolean',
            'user_id'    => 'required'
        ]);

        $request = $request->all();
        if(in_array('all',$request['user_id'])){
            $users = User::where('confirmed',1)->pluck('id')->toArray();
            $this->sendMessage($users,$request['subject'],$request['message'],$request['status']);
        }else{
            $this->sendMessage($request['user_id'],$request['subject'],$request['message'],$request['status']);
        }

        alert()->flash('ارسال شد', 'success', [
            'text' => "پیام با موفقیت به کاربران ارسال شد",
            'type' => 'success',
            'timer' => 1500,
        ]);

        return redirect(route('message.list'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param MsMessage $msMessage
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function edit(MsMessage $msMessage)
    {
        return view('CRM.SiteFront.messages.edit')->with(['message' => $msMessage]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param MsMessage $msMessage
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function update(Request $request, MsMessage $msMessage)
    {
        $this->validate($request,[
            'subject'    => 'required|string|max:255',
            'message'    => 'required|string|max:60000',
            'status'     => 'required|boolean',
        ]);

        $request = $request->all();

        $msMessage->update([
            'subject' => $request['subject'],
            'body'    => $request['message'],
            'status'  => $request['status']
        ]);

        alert()->flash('ویرایش شد', 'success', [
            'text' => "پیام با موفقیت ویرایش شد",
            'type' => 'success',
            'timer' => 1200,
        ]);

        return redirect(route('message.list'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function destroyUser(MsParticipant $msParticipant)
    {

        deleteRecord($msParticipant,'کاربر با موفقیت از این پیام حذف شد');

        return redirect()->back();
    }

    public function messageView(Request $request){
        $this->validate($request,[
            'id' => 'required|numeric|min:1|exists:ms_messages,id'
        ]);

        $message = MsMessage::whereId($request['id'])->first();

        return view('CRM.SiteFront.messages.viewModalInclude',compact('message'));
    }

    public function usersAdd(Request $request,MsMessage $msMessage){
        $this->validate($request,[
            'user_id'    => 'required'
        ]);

        $request = $request->all();

        if(in_array('all',$request['user_id'])){
            $users = User::where('confirmed',1)->pluck('id')->toArray();
        }else{
            $users = $request['user_id'];
        }

        foreach ($users as $user_id){

            $pivot = MsParticipant::where('user_id',$user_id)->where('ms_id',$msMessage->id)->first();

            if(!isset($pivot)){
                MsParticipant::create([
                    'ms_id'      => $msMessage->id,
                    'user_id'    => $user_id,
                    'seen'       => Null
                ]);
            }
        }

        alert()->flash('ارسال شد', 'success', [
            'text' => "پیام با موفقیت به کاربران ارسال شد",
            'type' => 'success',
            'timer' => 1200,
        ]);

        return redirect()->back();
    }

    public function sendMessage($user_ids,$subject,$message,$status){

        $ms = MsMessage::create([
            'subject' => $subject,
            'body'    => $message,
            'status'  => $status
        ]);

        foreach ($user_ids as $user_id){

            MsParticipant::create([
                'ms_id'      => $ms->id,
                'user_id'    => $user_id,
                'seen'       => Null
            ]);
        }
    }
}
