<?php

namespace App\Http\Controllers\CrmSiteFront\article;


use App\Http\Requests\ArticleRequest;
use App\Models\Article;
use App\Models\ArticleCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

class ArticleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $articles = Article::latest()->get();
        return view('CRM.SiteFront.articles.index', compact('articles'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categoreis=ArticleCategory::all();
        return view('CRM.SiteFront.articles.create', compact('categoreis'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(ArticleRequest $request)
    {
        $image = $request->file('image');
        $path = $this->uploadImages($image, 830, 479);
        $thumb_path = $this->uploadImages($image, 400, 231);

        $status = $request->status == 'on' ? 1 : 0;

        Article::create([
            'category_id' => $request->category,
            'title' => $request->title,
            'description' => $request->description,
            'body' => $request->body,
            'image_path' => $path,
            'thumb_path' => $thumb_path,
            'user_id' => auth()->user()->id,
            'tags' => $request->tags,
            'status' => $status,
        ]);

        alert()->flash('ثبت شد!', 'success', [
            'text' => "مقاله جدید با موفقیت ثبت شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);
        return redirect(route('article.index'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $categoreis=ArticleCategory::all();
        $article=Article::find($id);
        return view('CRM.SiteFront.articles.edite',compact('article','categoreis'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(ArticleRequest $request, $id)
    {
        $article=Article::find($id);
        $image = $request->file('image');


        $status = $request->status == 'on' ? 1 : 0;

        if (! is_null($image)) {
            if ($article) {
                \File::delete(public_path() . $article->image_path);
                \File::delete(public_path() . $article->thumb_path);
            }
            $path = $this->uploadImages($image, 830, 479);
            $thumb_path = $this->uploadImages($image, 400, 231);

        } else {
            $path = $article->image_path;
            $thumb_path=$article->thumb_path;
        }

        $article->update([
            'category_id' => $request->category,
            'title' => $request->title,
            'description' => $request->description,
            'body' => $request->body,
            'image_path' => $path,
            'thumb_path' => $thumb_path,
            'user_id' => auth()->user()->id,
            'tags' => $request->tags,
            'status' => $status,
        ]);

        alert()->flash('ویرایش شد!', 'success', [
            'text' => "دسته مورد نظر با موفقیت ویرایش شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return redirect(route('article.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $article = Article::find($id);
        \File::delete(public_path() . $article->image_path);
        \File::delete(public_path() . $article->thumb_path);
        deleteRecord($article);
        return back();
    }

    public function status_chenge($id){
        $article = Article::find($id);
        if ($article->status==1){
            $article->update(['status'=>0]);

            alert()->flash('انجام شد!', 'success', [
                'text' => "مقاله مورد نظر غیر فعال شد.",
                'type' => 'success',
                'timer' => 1400,

            ]);

        }else{
            $article->update(['status'=>1]);
            alert()->flash('انجام شد!', 'success', [
                'text' => "مقاله مورد نظر فعال شد.",
                'type' => 'success',
                'timer' => 1400,

            ]);
        }

        return back();

    }


    protected function uploadImages($file, $width, $height)

    {
        $imagePath = '/app/articles/';

//        File::exists(public_path($imagePath)) or File::makeDirectory(public_path($imagePath));


//-------------------big-----------------\

        $fileName1 = time() . rand(100, 999).'.'.$file->getClientOriginalExtension();


        $resize_filePath = public_path('/app/articles/' . $fileName1);

        $resize_dirPath = '/app/articles/';

//        $file->move($resize_dirPath,$fileName1);
        $this->resizeImage($file, $resize_dirPath, $resize_filePath, $width, $height);
        $public_path = '/app/articles/' . $fileName1;
        return $public_path;
    }

    protected static function resizeImage($file, $resize_dirPath, $resize_filePath, $width, $height)
    {
//        File::exists(public_path($resize_dirPath)) or File::makeDirectory(public_path($resize_dirPath));
// open an image file
        $img = Image::make($file->getRealPath());

// now you are able to resize the instance
        $img->resize($width, $height);

//save image to resize_filePath
        $img->save($resize_filePath);

    }

}
