<?php

namespace App\Http\Controllers\CrmSiteFront\article;


use App\Http\Requests\ArticleRequest;
use App\Models\ArticleCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Validator;

class ArticleCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $categories = ArticleCategory::all();
        return view('CRM.SiteFront.articleCategory.index', compact('categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('CRM.SiteFront.articleCategory.create');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
        ]);
        if ($validator->fails()) {
            return back()
                ->withErrors($validator)
                ->withInput();
        }

        ArticleCategory::create([
            'name' => $request->name,
        ]);

        alert()->flash('ثبت شد!', 'success', [
            'text' => "دسته جدید با موفقیت ثبت شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);
        return redirect(route('articleCategory.index'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $articleCategory=ArticleCategory::find($id);
        return view('CRM.SiteFront.articleCategory.edite',compact('articleCategory'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $article=ArticleCategory::find($id);

        $article->update([
            'name' => $request->name,
        ]);

        alert()->flash('ویرایش شد!', 'success', [
            'text' => "دسته مورد نظر با موفقیت ویرایش شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return redirect(route('articleCategory.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $article = ArticleCategory::find($id);

        deleteRecord($article);

        return back();
    }


}
