<?php

namespace App\Http\Controllers\CrmSiteFront\amazing;

use App\Http\Requests\AmazingRequest;
use App\Models\Amazing;
use App\Models\Products;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Morilog\Jalali\Facades\jDateTime;

class AmazingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $amazings=Amazing::all();
        return view('CRM.SiteFront.amazing.index',compact('amazings'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $products=Products::where('discount_sell_price','!=', '')->get();
        return view('CRM.SiteFront.amazing.create',compact('products'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(AmazingRequest $request)
    {
        $start="$request->start $request->startTime";
        $start = $carbon = jDatetime::createDatetimeFromFormat('Y/m/d H:i:s', $start) ;
        $end="$request->end $request->endTime";
        $end = $carbon = jDatetime::createDatetimeFromFormat('Y/m/d H:i:s', $end);

        if ($start > $end){
            return back()->withErrors('تاریخ پایان باید بعد از تاریخ شروع باشد.');
        }
        $request->status =='on' ? $status=1 :$status=0;

        Amazing::insert([
            'title'=>$request->title,
            'start'=>$start,
            'end'=>$end,
            'product_id'=>$request->product_id,
            'description'=>$request->description,
            'status'=>$status,
            'order'=>$request->order,
        ]);

        alert()->flash('ثبت شد!', 'success', [
            'text' => "شگفت انگیز با موفقیت ثبت شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return redirect(route('amazing.index'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $amazing=Amazing::find($id);
        $products=Products::where('discount_sell_price','!=', '')->get();
        return view('CRM.SiteFront.amazing.edite',compact('amazing','products'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(AmazingRequest $request, $id)
    {
        $amazing=Amazing::find($id);

        $start="$request->start $request->startTime";
        $start = $carbon = jDatetime::createDatetimeFromFormat('Y/m/d H:i:s', $start) ;
        $end="$request->end $request->endTime";
        $end = $carbon = jDatetime::createDatetimeFromFormat('Y/m/d H:i:s', $end);

        if ($start > $end){
            return back()->withErrors('تاریخ پایان باید بعد از تاریخ شروع باشد.');
        }
        $request->status =='on' ? $status=1 :$status=0;

        $amazing->update([
            'title'=>$request->title,
            'start'=>$start,
            'end'=>$end,
            'product_id'=>$request->product_id,
            'description'=>$request->description,
            'status'=>$status,
            'order'=>$request->order
        ]);
        alert()->flash('ویرایش شد!', 'success', [
            'text' => "با موفقیت ویرایش شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);
        return redirect(route('amazing.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $amazing = Amazing::find($id);
        deleteRecord($amazing);

        return back();
    }

    public function status_chenge($id){
        $amazing = Amazing::find($id);
        if ($amazing->status==1){
            $amazing->update(['status'=>0]);

            alert()->flash('انجام شد!', 'success', [
                'text' => " غیر فعال شد.",
                'type' => 'success',
                'timer' => 1400,

            ]);

        }else{
            $amazing->update(['status'=>1]);
            alert()->flash('انجام شد!', 'success', [
                'text' => " فعال شد.",
                'type' => 'success',
                'timer' => 1400,

            ]);
        }

        return back();

    }

}
