<?php

namespace App\Http\Controllers\CrmSiteFront;

use App\Http\Controllers\Controller;
use App\Models\Brands;
use App\Models\Category;
use App\Models\DynamicSubMenu;
use App\Models\DynamicSubMenuSetting;
use App\Models\ProductsTecInfo;
use App\Models\SubMenuTitle;
use Illuminate\Http\Request;

class SubMenuSettingController extends Controller
{

    /**
     * Show the form for creating a new resource.
     *
     * @param $subMenu_id
     * @return \Illuminate\Http\Response
     * @internal param Request $request
     */
    public function create($subMenu_id)
    {
        $dynamicSubMenu = DynamicSubMenu::whereId($subMenu_id)->first();
        $categories = Category::latest()->get();
        $dynamicSubMenus = DynamicSubMenu::latest()->get();

        return view('CRM.SiteFront.subMenuSetting.create', compact('dynamicSubMenus','categories','dynamicSubMenu'));
    }

    public function save(Request $request)
    {
        $this->validate($request,[
            'type'        => 'required|integer|min:0|max:2',
            'title'       => 'required|string',
            'subMenu_id'  => 'required|numeric|min:1|exists:dynamic_sub_menus,id',
            'category_id' => 'required_if:type,==,0|required_if:type,==,1|numeric|min:1|exists:category,id',
            'url'         => 'required_if:type,==,2|url',
            'priority'    => 'required|min:1|numeric',

        ]);

        $request = $request->all();
        if($request['type'] == 0 || $request['type'] == 1 ){
            SubMenuTitle::create(
                [
                    'title'       => $request['title'],
                    'sub_menu_id' => $request['subMenu_id'],
                    'category_id' => $request['category_id'],
                    'priority'    => $request['priority'],
                    'type'        => $request['type']
                ]);
        }elseif ($request['type'] == 2){
            SubMenuTitle::create(
                [
                    'title'       => $request['title'],
                    'sub_menu_id' => $request['subMenu_id'],
                    'priority'    => $request['priority'],
                    'url'         => $request['url'],
                    'type'        => $request['type']
                ]);
        }


        alert()->flash('ثبت شد', 'success', [
            'text' => 'عنوان با موفقیت ثبت شد',
            'timer' => 1200
        ]);

        return redirect(url('/CRM/SiteFront/dynamicSubMenu/' . $request['subMenu_id']));

    }

    /*
     * brand    => 1
     * category => 2
     * tecinfo  => 3
     * url      => 4
     */

    public function storeSubTitle(Request $request){
        $this->validate($request,[
            'title_type'    => 'required|numeric|min:1|max:4',
            'title_id'      => 'required|integer|min:1|exists:sub_menu_titles,id',
            'sub_title'     => 'required|string',
            'brand_id'      => 'required_if:title_type,==,1|integer|min:1|exists:brands,id',
            'category_id'   => 'required_if:title_type,==,1|required_if:title_type,==,2|required_if:title_type,==,3|integer|min:1|exists:category,id',
            'tec_code'      => 'required_if:title_type,==,3|string|exists:products_tecinfo,code',
            'tec_id'        => 'required_if:title_type,==,3|numeric|exists:tec_info_products,tec_id',
            'url'           => 'required_if:title_type,==,4|url',
            'priority'      => 'required|numeric|min:1',
        ]);

        $request = $request->all();
        if($request['title_type'] == 1){
            DynamicSubMenuSetting::create(
                [
                    'title_id'      => $request['title_id'],
                    'sub_title'     => $request['sub_title'],
                    'title_type'    => $request['title_type'],
                    'category_id'   => $request['category_id'],
                    'brand_id'      => $request['brand_id'],
                    'priority'      => $request['priority'],
                    'url'           => make_url($request['title_type'], $request['category_id'],$request['brand_id'])
                ]);
        }
        elseif ($request['title_type'] == 2)
        {
            DynamicSubMenuSetting::create(
                [
                    'title_id'      => $request['title_id'],
                    'sub_title'     => $request['sub_title'],
                    'title_type'    => $request['title_type'],
                    'category_id'   => $request['category_id'],
                    'brand_id'      => Null,
                    'priority'      => $request['priority'],
                    'url'           => make_url($request['title_type'], $request['category_id'])
                ]);
        }
        elseif ($request['title_type'] == 3)
        {
            DynamicSubMenuSetting::create(
                [
                    'title_id'      => $request['title_id'],
                    'sub_title'     => $request['sub_title'],
                    'title_type'    => $request['title_type'],
                    'category_id'   => $request['category_id'],
                    'brand_id'      => Null,
                    'priority'      => $request['priority'],
                    'tec_code'      => $request['tec_code'],
                    'tec_id'        => $request['tec_id'],
                    'url'           => make_url($request['title_type'], $request['category_id'],Null,$request['tec_id'],$request['tec_code'])

                ]);
        }
        elseif ($request['title_type'] == 4)
        {
            DynamicSubMenuSetting::create(
                [
                    'title_id'      => $request['title_id'],
                    'sub_title'     => $request['sub_title'],
                    'title_type'    => $request['title_type'],
                    'category_id'   => Null,
                    'brand_id'      => Null,
                    'priority'      => $request['priority'],
                    'tec_code'      => Null,
                    'tec_id'        => Null,
                    'url'           => $request['url']

                ]);
        }

        alert()->flash('ثبت شد', 'success', [
            'text' => "زیر عنوان با موفقیت ثبت شد",
            'timer' => 1200,
        ]);

        return redirect()->back();
    }

    public function delete(Request $request)
    {

        if($request->has('data')){
            foreach ($request->input('data') as $id){
                deleteSimple(SubMenuTitle::whereId($id)->first());
            }
        }

        $titles = SubMenuTitle::orderBy('id', 'desc')->latest()->paginate(25);

        return view('CRM.SiteFront.subMenuSetting.tab1',compact('titles'));
    }

    public function delete2(Request $request)
    {
        if($request->has('data')){
            foreach ($request->input('data') as $id){
                deleteSimple(DynamicSubMenuSetting::whereId($id)->first());
            }
        }

        $titles = SubMenuTitle::where('sub_menu_id',$request['subMenuId'])->latest()->paginate(25);
        $subMenuSetting = array();
        foreach ($titles as $title){
            $subMenuSetting[] = $title->SubMenuSetting()->latest()->get();
        }

        return view('CRM.SiteFront.subMenuSetting.tab2',compact('subMenuSetting'));
    }


    public function get_tec_keys(Request $request)
    {
        if(!$request->ajax()){
            return redirect()->back();
        }

        $request =  $request->all();

        $tecInfos = ProductsTecInfo::where('category_id',$request['cat_id'])
            ->where('parent_id','!=',0)
            ->where('status',1)
            ->get();

        return $tecInfos;
    }
    public function get_tec_values(Request $request)
    {
        if(!$request->ajax()){
            return redirect()->back();
        }

        $request =  $request->all();

        $tec_key = ProductsTecInfo::where('code',$request['tec_code'])->first();

        $tecInfos = $tec_key->TecInfoProducts()->groupBy('value')->get();

        return $tecInfos;
    }

    protected function edit_title(DynamicSubMenu $dynamicSubMenu,SubMenuTitle $subMenuTitle){

        $categories = Category::latest()->get();

        $dynamicSubMenus = DynamicSubMenu::latest()->get();

        return view('CRM.SiteFront.subMenuSetting.edit-title',compact('dynamicSubMenus','categories','dynamicSubMenu','subMenuTitle'));

    }

    protected function edit_subTitle(SubMenuTitle $subMenuTitle,DynamicSubMenuSetting $dynamicSubMenuSetting){


        $subMenuTitles = SubMenuTitle::latest()->get();
        $subTitle = $dynamicSubMenuSetting;

        if($dynamicSubMenuSetting->title_type == 1){
            $brands = Brands::get();
            $categories = Category::get();
            return view('CRM.SiteFront.subMenuSetting.edit-subTitle-brand',
                compact(
                    'subMenuTitles','subTitle','subMenuTitle','brands','categories'
                )
            );

        }elseif($dynamicSubMenuSetting->title_type == 2){
            $categories = Category::get();
            return view('CRM.SiteFront.subMenuSetting.edit-subTitle-category',
                compact(
                    'subMenuTitles','subTitle','subMenuTitle','categories'
                )
            );

        }elseif($dynamicSubMenuSetting->title_type == 3){
            $categories = Category::get();
            $category = $dynamicSubMenuSetting->Category()->first();
            $tecInfos = $category->TecInfo()
                ->where('parent_id','!=',0)
                ->where('status',1)
                ->get();

            $tecInfoKey = ProductsTecInfo::where('code',$dynamicSubMenuSetting->tec_code)->first();

            $tec_values = $tecInfoKey->TecInfoProducts()->get();

            return view('CRM.SiteFront.subMenuSetting.edit-subTitle-tecInfo',
                compact(
                    'tec_values','subMenuTitles','subTitle','subMenuTitle','categories','tecInfos'
                )
            );
        }elseif($dynamicSubMenuSetting->title_type == 4){

            return view('CRM.SiteFront.subMenuSetting.edit-subTitle-url',
                compact('subMenuTitles','subTitle','subMenuTitle')
            );
        }

    }


    protected function update_subTitle(SubMenuTitle $subMenuTitle,DynamicSubMenuSetting $dynamicSubMenuSetting,Request $request){
        $this->validate($request,[
            'title_type'    => 'required|numeric|min:1|max:4',
            'title_id'      => 'required|integer|min:1|exists:sub_menu_titles,id',
            'sub_title'     => 'required|string',
            'brand_id'      => 'required_if:title_type,==,1|integer|min:1|exists:brands,id',
            'category_id'   => 'required_if:title_type,==,1|required_if:title_type,==,2|required_if:title_type,==,3|integer|min:1|exists:category,id',
            'tec_code'      => 'required_if:title_type,==,3|string|exists:products_tecinfo,code',
            'tec_id'        => 'required_if:title_type,==,3|numeric|exists:tec_info_products,tec_id',
            'url'           => 'required_if:title_type,==,4|url',
            'priority'      => 'required|numeric|min:1',
        ]);

        $request =  $request->all();

        $dynamicSubMenuSetting->update(
            [
                'title_id'      => $request['title_id'],
                'sub_title'     => $request['sub_title'],
                'priority'      => $request['priority'],
            ]);

        if($dynamicSubMenuSetting->title_type == 1){

            $dynamicSubMenuSetting->update(
                [
                    'category_id'   => $request['category_id'],
                    'brand_id'      => $request['brand_id'],
                    'url'           => make_url(1, $request['category_id'],$request['brand_id'])
                ]);

        }elseif($dynamicSubMenuSetting->title_type == 2){
            $dynamicSubMenuSetting->update(
                [
                    'category_id'   => $request['category_id'],
                    'url'           => make_url(2, $request['category_id'])
                ]);

        }elseif($dynamicSubMenuSetting->title_type == 3){
            $dynamicSubMenuSetting->update(
                [
                    'category_id'   => $request['category_id'],
                    'tec_code'      => $request['tec_code'],
                    'tec_id'        => $request['tec_id'],
                    'url'           => make_url(3, $request['category_id'],Null,$request['tec_id'],$request['tec_code'])
                ]);
        }elseif($dynamicSubMenuSetting->title_type == 4){

            $dynamicSubMenuSetting->update(
                [
                    'url'           => $request['url']
                ]);
        }

        alert()->flash('ویرایش شد', 'success', [
            'text' => 'زیر عنوان با موفقیت ویرایش شد',
            'timer' => 1300
        ]);

        return redirect(url('/CRM/SiteFront/dynamicSubMenu/' . $subMenuTitle->DynamicSubMenu()->first()->id));

    }

    public function update_title(DynamicSubMenu $dynamicSubMenu,SubMenuTitle $subMenuTitle,Request $request)
    {
        $this->validate($request,[
            'type'        => 'required|numeric|min:0|max:2',
            'title'       => 'required|string|max:255',
            'category_id' => 'required_if:type,==,0|required_if:type,==,1|numeric|min:1|exists:category,id',
            'url'         => 'required_if:type,==,2|url',
            'priority'    => 'required|min:1|integer',
        ]);

        $request = $request->all();

        if($request['type'] == 1 || $request['type'] == 0){
            $subMenuTitle->update(
                [
                    'title'       => $request['title'],
                    'sub_menu_id' => $request['subMenu_id'],
                    'category_id' => $request['category_id'],
                    'priority'    => $request['priority'],
                    'type'        => $request['type']
                ]);
        }else{
            $subMenuTitle->update(
                [
                    'title'       => $request['title'],
                    'sub_menu_id' => $request['subMenu_id'],
                    'url'         => $request['url'],
                    'priority'    => $request['priority'],
                    'type'        => $request['type']
                ]);
        }

        alert()->flash('ویرایش شد', 'success', [
            'text' => 'عنوان با موفقیت ویرایش شد',
            'timer' => 1100
        ]);

        return redirect(url('/CRM/SiteFront/dynamicSubMenu/' . $dynamicSubMenu->id));

    }


}
