<?php

namespace App\Http\Controllers\CrmSiteFront;

use App\Http\Controllers\Controller;
use App\Models\Baner;
use App\Models\Category;
use App\Models\NewestItem;
use Illuminate\Http\Request;
class newestItemsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $baners = Baner::whereType('home')->get();
        $categories = new Category();
        $categoriesInfo = $categories->all();

        return view('CRM.SiteFront.CatBanners.newestItems',compact('categoriesInfo','baners'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request = $request->all();
        unset($request['_token']);
        $newestItems = new NewestItem();
        foreach ($request as $key=>$value){
            if($value == 0){
                $newestItems->updateOrCreate(
                    ['category_field_name' => $key],
                    [
                        'category_id' => Null,
                        'status' => 0
                    ]
                );
            }else{
                $newestItems->updateOrCreate(
                    ['category_field_name' => $key],
                    [
                        'category_id' => $value,
                        'status' => 1
                    ]
                );

            }
        }
        $message = "بنر جدیدترین ها با موفقیت بروزرسانی شد";
        $messageType = "success";
        session()->flash('message', $message);
        session()->flash('messageType', $messageType);
        return redirect(route('newestItems.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
