<?php

namespace App\Http\Controllers\CrmSiteFront\Filters;

use App\Http\Requests\FilterTitleRequest;
use App\Models\Category;
use App\Models\FilterTitle;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;


class TitlesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index( )
    {
        $category = category::all();

        return view('CRM.SiteFront.filters.all',compact('category'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(FilterTitleRequest $request)
    {

        $request = $request->all();
        FilterTitle::create($request);

        $filterTitles = FilterTitle::where('category_id',$request['category_id'])->orderBy('status','desc')->latest()->get();
        $category = category::whereId($request['category_id'])->first();


        return view('CRM.SiteFront.filters.includeTitlesTable',compact('filterTitles','category'));
    }

    /**
     * Display the specified resource.
     *
     * @param $id
     * @return \Illuminate\Http\Response
     * @internal param category $category
     */
    public function show($id)
    {
        $category = category::find($id);

        $filterTitles = FilterTitle::where('category_id',$id)->orderBy('status','desc')->latest()->get();
        return view('CRM.SiteFront.filters.titles',compact('filterTitles','category'));

    }



    public function get(Request $request)
    {
        $request = $request->all();

        $filterTitle = FilterTitle::whereId($request['data'][0])->first();

        return $filterTitle;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function update(FilterTitleRequest $request)
    {
        $request = $request->all();

        $filterTitle = FilterTitle::whereId($request['id'])->first();

        $filterTitle->update([
            'name'      =>   $request['name'],
            'priority'  =>   $request['priority'],
            'status'    =>   $request['status'],
        ]);

        $filterTitles = FilterTitle::where('category_id',$request['category_id'])->orderBy('status','desc')->latest()->get();
        $category = category::whereId($request['category_id'])->first();

        return view('CRM.SiteFront.filters.includeTitlesTable',compact('filterTitles','category'));

    }


    public function delete(Request $request)
    {
        $request = $request->all();

        if(!empty($request['data']))
        {
            foreach($request['data'] as $value)
            {
                deleteSimple(FilterTitle::where('id',$value)->first());

            }
        }

        $filterTitles = FilterTitle::where('category_id',$request['cat'])->orderBy('status','desc')->latest()->get();
        $category = category::whereId($request['cat'])->first();

        return view('CRM.SiteFront.filters.includeTitlesTable',compact('filterTitles','category'));
    }
}
