<?php

namespace App\Http\Controllers\CrmSiteFront\Filters;

use App\Http\Requests\FilterOptionsRequest;
use App\Models\Filter;
use App\Models\FilterTitle;
use App\Models\ProductsTecInfo;
use App\Models\TecInfoProduct;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;


class OptionsController extends Controller
{


    /**
     * Store a newly created resource in storage.
     *
     * @param FilterOptionsRequest|Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(FilterOptionsRequest $request)
    {

        $request = $request->all();
        $request['url'] = 'tecInfo['. $request['tec_code'].']['.$request['tec_id'] .']='. $request['tec_id'];

        Filter::create($request);

        alert()->flash('ثبت شد', 'success', [
            'text' => "گزینه فیلتر با موفقیت ثبت شد",
            'timer' => 1100,
        ]);

        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param $id
     * @param Request $request
     * @return \Illuminate\Http\Response
     * @internal param category $category
     */
    public function show($id,Request $request)
    {
        $filterTitle = FilterTitle::find($id);

        $tecInfoKeys = ProductsTecInfo::where('category_id',$request['catId'] )
            ->where('parent_id','!=',0)
            ->where('status',1)
            ->get();

        $options = Filter::where('title_id',$id)->orderBy('status','desc')->latest()->get();

        return view('CRM.SiteFront.filters.options',compact('filterTitle','options','tecInfoKeys'));

    }


    public function edit(Filter $option){

        $tecInfoKeys = ProductsTecInfo::where('category_id',$option->FilterTitle->category_id )
            ->where('parent_id','!=',0)
            ->where('status',1)
            ->get();

        $tecInfoValues = TecInfoProduct::where('tecInfo_id',$option->TecInfoProduct->tecInfo_id)->get();

        return view('CRM.SiteFront.filters.option_edit',compact('tecInfoValues','tecInfoKeys','option'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Filter $option
     * @param FilterOptionsRequest|Request $request
     * @return \Illuminate\Http\Response
     */
    public function update(Filter $option,Request $request)
    {
        $this->validate($request,[
            'name'          => 'required|string',
            'tec_code'      => 'required|string|exists:products_tecinfo,code',
            'tec_id'        => 'required|numeric|exists:tec_info_products,tec_id',
            'priority'      => 'required|numeric|min:1',
            'status'        => 'required|numeric|min:0|max:1'
        ]);

        $request = $request->all();

        $request['url'] = 'tecInfo['. $request['tec_code'].']['.$request['tec_id'] .']='. $request['tec_id'];

        $option->update($request);

        alert()->flash('ویرایش شد', 'success', [
            'text' => "گزینه فیلتر با موفقیت ویرایش شد",
            'timer' => 1100,
        ]);

        return redirect(route('options.show' , ['id' => $option->FilterTitle->id ]));

    }


    public function delete(Request $request)
    {
        $request = $request->all();

        if(!empty($request['data']))
        {
            foreach($request['data'] as $value)
            {
                deleteSimple(Filter::where('id',$value)->first());
            }
        }

        $options = Filter::where('title_id',$request['title_id'])->orderBy('status','desc')->latest()->get();

        return view('CRM.SiteFront.filters.includeOptionsTable',compact('options'));
    }
}
