<?php

namespace App\Http\Controllers\CrmSiteFront;

use App\Http\Controllers\CrmSiteFront\DynamicMenu\DynamicMenuTrait;
use App\Http\Requests\DynamicSubMenuRequest;
use App\Models\Brands;
use App\Models\Category;
use App\Models\DynamicMenu;
use App\Models\DynamicSubMenu;
use App\Models\DynamicSubMenuSetting;
use App\Models\SubMenuTitle;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Input;

class DynamicSubMenuController extends Controller
{
    use DynamicMenuTrait;

    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     * @return \Illuminate\Http\Response
     * @internal param $id
     */
    public function index(Request $request)
    {

    }

    /**
     * Show the form for creating a new resource.
     *
     * @param DynamicMenu $dynamicMenu
     * @return \Illuminate\Http\Response
     * @internal param Request $request
     */
    public function create(DynamicMenu $dynamicMenu)
    {

        $categories = Category::all();

        return view('CRM.SiteFront.dynamicSubMenu.create', compact('dynamicMenu','categories'));
    }

    public function createUrl(DynamicMenu $dynamicMenu)
    {
        return view('CRM.SiteFront.dynamicSubMenu.create-url', compact('dynamicMenu'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request,[
            'type'              => 'required|numeric|min:1|max:2',
            'name'              => 'required|string',
            'dynamic_menu_id'   => 'required|integer',
            'category_id'       => 'required_if:type,==,1',
            'url'               => 'required_if:type,==,2'
        ]);
        $req = $request;
        $request = $request->all();

        if ($request['type'] == 1) {
            $this->validate($req,[
                'category_id'       => 'numeric|exists:category,id',
            ]);
            $category = category::whereId($request['category_id'])->first();
            DynamicSubMenu::create([
                'name'              => $request['name'],
                'dynamic_menu_id'   => $request['dynamic_menu_id'],
                'category_id'       => $request['category_id'],
                'cat_name'          => $category->category
            ]);
        }elseif($request['type'] == 2){
            $this->validate($req,[
                'url'               => 'url'
            ]);
            DynamicSubMenu::create([
                'name'              => $request['name'],
                'dynamic_menu_id'   => $request['dynamic_menu_id'],
                'url'               => $request['url'],
            ]);
        }

        alert()->flash('ثبت شد', 'success', [
            'text' => "رکورد جدید با موفقیت ثبت شد",
            'type' => 'success',
            'timer' => 1200,
        ]);

        return redirect('/CRM/SiteFront/dynamicMenu/' . $request['dynamic_menu_id']);
    }

    /**
     * Display the specified resource (submenu).
     *
     * @param Request $request
     * @param $subMenu_id
     * @return \Illuminate\Http\Response
     * @internal param DynamicMenu $dynamicMenu
     */
    public function show(Request $request,$subMenu_id)
    {

        $dynamicSubMenu = DynamicSubMenu::whereId($subMenu_id)->first();

        $titles = SubMenuTitle::where('sub_menu_id',$subMenu_id)->latest()->paginate(25);
        $form_titles = SubMenuTitle::where('sub_menu_id',$subMenu_id)->latest()->get();

        $subMenuSetting = array();
        foreach ($titles as $title){
            $subMenuSetting[] = $title->SubMenuSetting()->latest()->get();
        }
        $categories = Category::all();

        $brands = Brands::all();

        return view('CRM.SiteFront.subMenuSetting.all', compact('form_titles','dynamicSubMenu','titles','categories','brands','subMenuSetting'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\DynamicSubMenu $dynamicSubMenu
     * @param Request $request
     * @return \Illuminate\Http\Response
     */
    public function edit(DynamicSubMenu $dynamicSubMenu)
    {
        $categories = Category::all();
        $dynamicMenu = $dynamicSubMenu->DynamicMenu()->first();
        return view('CRM.SiteFront.dynamicSubMenu.edit', compact('dynamicSubMenu','categories','dynamicMenu'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \App\Models\DynamicSubMenu $dynamicSubMenu
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DynamicSubMenu $dynamicSubMenu)
    {

        $this->validate($request,[
            'type'              => 'required|numeric|min:1|max:2',
            'name'              => 'required|string',
            'category_id'       => 'required_if:type,==,1',
            'url'               => 'required_if:type,==,2'
        ]);

        $req = $request;
        $request = $request->all();

        if($request['type'] == 1) {
            $this->validate($req,[
                'category_id'       => 'numeric|exists:category,id',
            ]);

            $category = category::whereId($request['category_id'])->first();
            $dynamicSubMenu->update([
                'type'                  => $request['type'],
                'name'                  => $request['name'],
                'dynamic_menu_id'       => $request['dynamic_menu_id'],
                'category_id'           => $request['category_id'],
                'cat_name'              => $category->category,
                'slug'                  => ''
            ]);
        }else{
            $this->validate($req,[
                'url'               => 'url'
            ]);
            $dynamicSubMenu->update([
                'type'              => $request['type'],
                'name'              => $request['name'],
                'dynamic_menu_id'   => $request['dynamic_menu_id'],
                'url'               => $request['url']
            ]);
        }

        alert()->flash('ویرایش شد', 'success', [
            'text' => "رکورد با موفقیت ویرایش شد",
            'type' => 'success',
            'timer' => 1200,
        ]);

        return redirect('/CRM/SiteFront/dynamicMenu/' . $request['dynamic_menu_id']);

    }


    public function delete(Request $request)
    {
        if($request->has('data')){
            foreach ($request->input('data') as $id){
                deleteSimple(DynamicSubMenu::whereId($id)->first());
            }
        }

        $dynamicMenus = DynamicMenu::whereId($request['id'])->first();
        $dynamicSubMenu = DynamicSubMenu::where('dynamic_menu_id', $request['id'])->orderBy('priority', 'desc')->latest()->paginate(25);
        return view('CRM.SiteFront.dynamicSubMenu.subMenuTablesInclude', compact('dynamicSubMenu', 'dynamicMenus'));
    }


    protected function subMenuActivation(Request $request)
    {
        $request = $request->all();

        $subMenu = new DynamicSubMenu();
        $menuId = $request['menuId'];

        $check = array_count_values($request['dynamicSubMenu']);

        foreach ($check as $key => $value) {
            if ($key !== 0) {
                if ($value > 1) {
                    return $message = 103;
                }
            }

        }
        for ($i = 0; $i < $this->subMenuNumber; $i++) {

            if ($request['dynamicSubMenu'][$i] == 0) {

                $subMenu->where('dynamic_menu_id', $menuId)->where('priority', $i + 1)->where('status', 1)
                    ->update(
                        ['status' => 0, 'priority' => Null]
                    );

            } else {
                $subMenu->whereId($request['dynamicSubMenu'][$i])
                    ->update(
                        ['status' => 1, 'priority' => $i + 1]
                    );
            }
        }

        if (isset($check["0"])) {
            if ($check["0"] == $this->subMenuNumber) {

                $message = 104;
                return $message;

            }
        }
        return $message = 200;
    }

    protected function subMenuTableRefresh(Request $request)
    {
        $request = $request->all();

        $dynamicMenus = DynamicMenu::whereId($request['id'])->first();
        $dynamicSubMenu = DynamicSubMenu::where('dynamic_menu_id', $request['id'])->orderBy('priority', 'desc')->latest()->paginate(25);

        return view('CRM.SiteFront.dynamicSubMenu.subMenuTablesInclude', compact('dynamicMenus', 'dynamicSubMenu'));

    }

    protected function activation_button(Request $request)
    {
        $request = $request->all();

        $dynamicSubMenus = DynamicSubMenu::where('dynamic_menu_id', $request['id'])->where('status',1)->orderBy('priority', 'asc')->skip(0)->take(10)->get();
        $dynamicSubMenuId = array();
        foreach ($dynamicSubMenus as $dynamicSubMenu){
            $dynamicSubMenuId[] = $dynamicSubMenu->id;
        }

        return $dynamicSubMenuId;
    }


    protected function paginate($items,$perPage,$request)
    {

        $page = Input::get('page', 1); // Get the current page or default to 1

        $offset = ($page * $perPage) - $perPage;

        return new LengthAwarePaginator(
            array_slice($items, $offset, $perPage, true),
            count($items), $perPage, $page,
            ['path' => $request->url(), 'query' => $request->query()]
        );
    }
}