<?php

namespace App\Http\Controllers\CrmSiteFront;

use App\Helpers\SmsTemplates;
use App\Http\Controllers\CrmSiteFront\DynamicMenu\DynamicMenuTrait;
use App\Http\Requests\DynamicMenuRequest;
use App\Models\DynamicMenu;
use App\Models\DynamicMenuSlot;
use App\Models\DynamicSubMenu;
use App\Models\StuffType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DynamicMenuController extends Controller
{
    use DynamicMenuTrait;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $dynamicMenu    =   DynamicMenu::orderBy('status', 'desc')->latest()->paginate(25);
        $menuSlots      =   DynamicMenuSlot::all();

        return view('CRM.SiteFront.dynamicMenu.all', compact('dynamicMenu','menuSlots'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $stuffTypes = StuffType::all();

        return view('CRM.SiteFront.dynamicMenu.create',compact('stuffTypes'));
    }

    public function createUrl(){

        return view('CRM.SiteFront.dynamicMenu.create-url');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param DynamicMenuRequest $request2
     * @return \Illuminate\Http\Response
     * @internal param DynamicMenuRequest|Request $request
     */
    public function store(Request $request2)
    {

        $request = $request2->all();

        if ($request['type'] == 1){
            $this->validate($request2,[
                'name' => 'required|unique:dynamic_menus|string|max:100',
                'stuffType_id' => 'required|integer',
            ]);
            $stuffType = StuffType::whereId($request['stuffType_id'])->first();

            DynamicMenu::create([
                'type'              => $request['type'],
                'name'              => $request['name'],
                'stuffType_id'      => $stuffType->id,
                'stuffType_name'    => $stuffType->stuffType
            ]);
        }elseif($request['type'] == 2){
            $this->validate($request2,[
                'name'  =>   'required|unique:dynamic_menus|string|max:100',
                'url'   =>   'required|url',
            ]);
            DynamicMenu::create([
                'type'              => $request['type'],
                'name'              => $request['name'],
                'url'               => $request['url']
            ]);
        }

        alert()->flash('ثبت شد!', 'success', [
            'text' => "رکورد جدید با موفقیت ثبت شد.",
            'type' => 'success',
            'timer' => 1200,

        ]);

        return redirect(route('dynamicMenu.index'));
    }


    public function show($menu_id)
    {

        $dynamicMenus = DynamicMenu::whereId($menu_id)->first();
        $dynamicSubMenu = DynamicSubMenu::where('dynamic_menu_id',$menu_id)->orderBy('priority', 'desc')->latest()->paginate(25);
        return view('CRM.SiteFront.dynamicSubMenu.all', compact('dynamicSubMenu','dynamicMenus'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\DynamicMenu $dynamicMenu
     * @return \Illuminate\Http\Response
     */
    public function edit(DynamicMenu $dynamicMenu)
    {
        $stuffTypes = StuffType::all();

        return view('CRM.SiteFront.dynamicMenu.edit', compact('stuffTypes','dynamicMenu'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \App\Models\DynamicMenu $dynamicMenu
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DynamicMenu $dynamicMenu)
    {

        $this->validate($request,[
            'type'              => 'required|numeric|min:1|max:2',
            'name'              => 'required|string|max:100|unique:dynamic_menus,name,'.$dynamicMenu->id,
            'stuffType_id'      => 'required_if:type,==,1',
            'url'               => 'required_if:type,==,2|url'
        ]);
        $request = $request->all();
        $req = $request;

        if($request['type'] == 1){

            $this->validate($req,[
                'stuffType_id'       => 'numeric|exists:stufftype,id',
            ]);

            $stuffType = StuffType::whereId($request['stuffType_id'])->first();

            $dynamicMenu->update([
                'type'              => $request['type'],
                'name'              => $request['name'],
                'stuffType_id'      => $stuffType->id,
                'stuffType_name'    => $stuffType->stuffType
            ]);

        }else{
            // $this->validate($req,[
            //     'url'               => 'url'
            // ]);
            $dynamicMenu->update([
                'type'              => $request['type'],
                'name'              => $request['name'],
                'url'               => $request['url']
            ]);

        }

        alert()->flash('ویرایش شد', 'success', [
            'text' => "رکورد با موفقیت ویرایش شد",
            'type' => 'success',
            'timer' => 1200,
        ]);

        return redirect(route('dynamicMenu.index'));
    }



    public function delete(Request $request)
    {

        if($request->has('data')){
            foreach ($request->input('data') as $id){
                deleteSimple(DynamicMenu::whereId($id)->first());
            }
        }

        $dynamicMenu = DynamicMenu::orderBy('status', 'desc')->latest()->paginate(25);

        return view('CRM.SiteFront.dynamicMenu.menuTablesInclude',compact('dynamicMenu'));
    }


    protected function menuActivation(Request $request)
    {
        $request = $request->all();
        $menuSlot = new DynamicMenuSlot();
        $dynamicMenu = new DynamicMenu();

        $check = array_count_values($request['dynamicMenu']);

        foreach ($check as $key => $value) {
            if ($key !== 0) {
                if ($value > 1) {
                    return $message = 103;
                }
            }

        }
        for ($i = 0; $i < $this->menuNumber; $i++) {
            $menuName = 'menu_' . ($i + 1);
            if($request['dynamicMenu'][$i] == 0) {
                $menuSlotInfo = $menuSlot->where('menu_slot_name', $menuName)->first();
                if(isset($menuSlotInfo) && !is_null($menuSlotInfo->dynamic_menu_id)) {
                    $dynamicMenuInfo = $menuSlot->where('menu_slot_name', $menuName)->first();
                    $dynamicMenuInfo->DynamicMenu()->first()->update(
                        ['status' => 0]
                    );
                    $menuSlot->where('menu_slot_name', $menuName)->first()->update(
                        ['dynamic_menu_id' => Null]
                    );
                }
                $menuSlot->updateOrCreate(
                    ['menu_slot_name' => $menuName],
                    ['status' => 0]
                );
            } else {
                $dynamicMenu->whereId($request['dynamicMenu'][$i])
                    ->update(
                        ['status' => 1]
                    );
                $menuSlot->updateOrCreate(
                    ['menu_slot_name' => $menuName],
                    ['status' => 1,'dynamic_menu_id' => $request['dynamicMenu'][$i]]
                );
            }
        }
        if(isset($check["0"])){
            if ($check["0"] == $this->menuNumber) {
                return $message = 104;
            }
        }
        return $message = 200;
    }

    protected function menuTableRefresh()
    {
        $dynamicMenu = DynamicMenu::orderBy('status', 'desc')->latest()->paginate(25);
        return view('CRM.SiteFront.dynamicMenu.menuTablesInclude', compact('dynamicMenu'));
    }

    protected function menu_activation_button()
    {
        $menuId = array();
        $menuId[0] = DynamicMenuSlot::where('menu_slot_name','menu_1')->first()->dynamic_menu_id;
        $menuId[1] = DynamicMenuSlot::where('menu_slot_name','menu_2')->first()->dynamic_menu_id;
        $menuId[2] = DynamicMenuSlot::where('menu_slot_name','menu_3')->first()->dynamic_menu_id;
        $menuId[3] = DynamicMenuSlot::where('menu_slot_name','menu_4')->first()->dynamic_menu_id;
        $menuId[4] = DynamicMenuSlot::where('menu_slot_name','menu_5')->first()->dynamic_menu_id;
        $menuId[5] = DynamicMenuSlot::where('menu_slot_name','menu_6')->first()->dynamic_menu_id;
        $menuId[6] = DynamicMenuSlot::where('menu_slot_name','menu_7')->first()->dynamic_menu_id;
        $menuId[7] = DynamicMenuSlot::where('menu_slot_name','menu_8')->first()->dynamic_menu_id;


        return $menuId;
    }
}
