<?php

namespace App\Http\Controllers\CrmSiteFront\DiscountCodes;

use App\Http\Requests\DiscountDeleteRequest;
use App\Http\Requests\DiscountRequest;
use App\Models\DiscountCode;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Morilog\Jalali\jDate;
use Morilog\Jalali\jDateTime;

class DiscountCodesController extends Controller
{

    protected function index(){

        $jdate = new jDate();
        $discountCodes = DiscountCode::withTrashed()->latest()->get();
        return view('CRM.SiteFront.discountCodes.all',compact('discountCodes','jdate'));
    }


    /*
    * ---------------------------------------------
    * discount types:
    * ---------------------------------------------
    * 1) discountType: amount
    * -> format(-0)
    * -> it means that the discount type is amount and the amount of discount is going to Subtract from price
    *
    * Usage: $totalPrice - amount
    * :::::::::::::::::::::::::
    * discount_type: 10 = (limitless amount)
    * discount_type: 20 = (amount with time limit)
    * discount_type: 30 = (amount with number limit)
    * discount_type: 40 = (amount with both number & time limit)
    *
    * -----------------/\/\/\/\/\/\/\/\/\/\/\/\/\
    * 2) discountType: percentage
    * -> format(-1)
    * -> it means that the discount type is percentage and the percentage of total price is going to Subtract from it
    *
    * Usage: $totalPrice - ( $totalPrice * percentage / 100)
    * ::::::::::::::::::::::::::
    * discount_type: 11 = (limitless percent)
    * discount_type: 21 = (percent with time limit)
    * discount_type: 31 = (percent with number limit)
    * discount_type: 41 = (percent with both number & time limit)
    */
    protected function store(DiscountRequest $request){


        $discount_code      = $this->randomId();

        $discount_code      = encrypt_decrypt('encrypt',$discount_code);

        $discount_type      = $request->discount_type;
        $amount             = $request->amount;

        if(isset($request->date) && isset($request->time)){
            $request2   = $request->all();
            $date       = $request2['date'];
            $time       = $request2['time'];
            $jdate      = "$date $time";

            $valid_date = $carbon = jDatetime::createDatetimeFromFormat('Y/m/d H:i:s', $jdate);
        }else{
            $valid_date = null;
        }
        $times_left = $request->number;

        if($discount_type == 10 || $discount_type == 20 || $discount_type == 30 || $discount_type == 40 ){

            DiscountCode::Create([
                'code'	            => $discount_code,
                'discount_type'     => $discount_type,
                'amount' 	        => $amount,
                'valid_time'        => $valid_date,
                'times_left'        => $times_left,
                'price_top'         => $request->price_top,
                'price_down'        => $request->price_down
            ]);
        }else{
            DiscountCode::Create([
                'code'	            => $discount_code,
                'discount_type'     => $discount_type,
                'percentage' 	    => $amount,
                'valid_time'        => $valid_date,
                'times_left'        => $times_left,
                'price_top'         => $request->price_top,
                'price_down'        => $request->price_down
            ]);
        }
        $jdate = new jDate();
        $discountCodes = DiscountCode::withTrashed()->latest()->get();
        return view('CRM.SiteFront.discountCodes.tableInclude',compact('discountCodes','jdate'));
    }

    protected function delete(DiscountDeleteRequest $request){
        $request = $request->all();

            try{
                DiscountCode::whereId($request['discount_code_id'])->forceDelete();
            }
            catch (\Illuminate\Database\QueryException $e) {
                DiscountCode::whereId($request['discount_code_id'])->delete();
            }

        $jdate = new jDate();
        $discountCodes = DiscountCode::withTrashed()->get();
        return view('CRM.SiteFront.discountCodes.tableInclude',compact('discountCodes','jdate'));
    }

    protected function deactivate(DiscountDeleteRequest $request){
        $request = $request->all();
        deleteSimple(DiscountCode::whereId($request['discount_code_id'])->first());

        $jdate = new jDate();
        $discountCodes = DiscountCode::withTrashed()->get();
        return view('CRM.SiteFront.discountCodes.tableInclude',compact('discountCodes','jdate'));
    }

    /*
     * error 99 = not valid time -> tarikh gozashte
     * error 88 = not valid times_left -> tedade ghabele estefade namande
     */
    protected function activate(DiscountDeleteRequest $request){
        $request = $request->all();
        $discountCode = DiscountCode::whereId($request['discount_code_id'])->withTrashed()->first();

        if($discountCode->discount_type == 20 || $discountCode->discount_type == 40 || $discountCode->discount_type == 21 || $discountCode->discount_type == 41){
            if($discountCode->valid_time->lt(Carbon::now())){
                return 99;
            }

        }elseif($discountCode->discount_type == 30 || $discountCode->discount_type == 40 || $discountCode->discount_type == 31 || $discountCode->discount_type == 41){
            if($discountCode->times_left <= 0){
                return 88;
            }
        }
        $discountCode->deleted_at = null;
        $discountCode->save();
        $jdate = new jDate();
        $discountCodes = DiscountCode::withTrashed()->get();
        return view('CRM.SiteFront.discountCodes.tableInclude',compact('discountCodes','jdate'));
    }

    protected function randomId(){

        $currentdayumber = date('N');

        switch ($currentdayumber){
            case 1:
                $code = random_int(111,999);
                $code .= str_random(2);
                $code .= str_random(3);
                $code .= random_int(1,9);
                $code .= str_random(2);
                break;
            case 2:
                $code = str_random(1);
                $code .= random_int(111,999);
                $code .= str_random(2);
                $code .= str_random(1);
                $code .= random_int(111,999);
                break;
            case 3:
                $code  = str_random(3);
                $code .= str_random(2);
                $code .= str_random(2);
                $code .= random_int(11,99);
                $code .= str_random(1);
                break;
            case 4:
                $code = random_int(11,99);
                $code .= str_random(6);
                $code .= random_int(11,99);
                break;
            case 5:
                $code = str_random(1);
                $code .= random_int(1111,9999);
                $code .= str_random(2);
                $code .= random_int(1,9);
                $code .= str_random(2);
                break;
            case 6:
                $code = str_random(2);
                $code .= str_random(3);
                $code .= random_int(11,99);
                $code .= str_random(1);
                $code .= random_int(11,99);
                break;
            case 7:
                $code = str_random(3);
                $code .= random_int(11,99);
                $code .= str_random(2);
                $code .= random_int(11,99);
                $code .= str_random(1);
                break;
        }

        $validator = Validator::make(['code'=>$code],['code'=>'unique:discount_codes,code']);

        if($validator->fails()){
            $this->randomId();
        }

        return $code;
    }
}
