<?php

namespace App\Http\Controllers\CrmSiteFront;


use App\Models\Review;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Morilog\Jalali\jDate;

class CommentsController extends Controller
{

    protected function index(){
        $comments = Review::latest()->get();
        $jdate = new jDate();
        return view('CRM.SiteFront.comments.all',compact('comments','jdate'));
    }

    protected function sectionIndex(){
        return view('CRM.SiteFront.comments.section');
    }

    protected function pendingIndex(){

        $comments = Review::where('confirmed',0)->latest()->get();

        $jdate = new jDate();

        $mode = 0;
        return view('CRM.SiteFront.comments.pending',compact('mode','comments','jdate'));
    }

    protected function approvedIndex(){
        $comments = Review::where('confirmed',1)->latest()->get();

        $jdate = new jDate();
        $mode = 1;
        return view('CRM.SiteFront.comments.approved',compact('mode','comments','jdate'));
    }

    protected function declinedIndex(){
        $comments = Review::where('confirmed',2)->latest()->get();

        $jdate = new jDate();
        $mode = 2;
        return view('CRM.SiteFront.comments.declined',compact('mode','comments','jdate'));
    }

    protected function change(Request $request)
    {

        $request = $request->all();

        $jdate = new jDate();
        Review::whereId($request['id'])->update([
            'confirmed' => $request['status']
        ]);
        if (isset($request['mode'])) {
            $mode = $request['mode'];
            $comments = Review::where('confirmed', $request['mode'])->latest()->get();
            return view('CRM.SiteFront.comments.tableInclude', compact('mode','comments', 'jdate'));
        } else {
            $comments = Review::latest()->get();
            return view('CRM.SiteFront.comments.allTableInclude', compact('comments', 'jdate'));
        }
    }

    protected function delete(Request $request){
        $request = $request->all();


        deleteRecord(Review::whereId($request['id'])->first());

        $comments = Review::where('confirmed',$request['mode'])->latest()->get();

        $jdate = new jDate();

        return view('CRM.SiteFront.comments.tableInclude',compact('comments','jdate'));

    }

    protected function editIndex(Review $review){

        return view('CRM.SiteFront.comments.edit',compact('review'));
    }

    protected function edit(Review $review,Request $request){

        $this->validate($request,[
            'text' => 'required|string',
            'confirmed' => 'integer|min:0|max:2'
        ]);
        $request = $request->all();

        $review->update([
            'text' => $request['text'],
            'confirmed' => $request['confirmed']
        ]);

        if($request['confirmed'] == 0){
            $message = "نظر با موفقیت ویرایش شد و به حالت تعلیق درآمد";
        }elseif($request['confirmed'] == 1){
            $message = "نظر با موفقیت ویرایش و تایید شد";
        }elseif($request['confirmed'] == 2){
            $message = "نظر با موفقیت ویرایش شده و تایید نشد";
        }

        alert()->flash('ویرایش شد', 'success', [
            'text' => $message,
            'timer' => 2000
        ]);

        $comments = Review::where('confirmed',0)->latest()->get();

        $jdate = new jDate();

        $mode = 0;

        return redirect('/CRM/comments/pending')->with([
            'mode' => $mode,
            'jdate' => $jdate,
            'comments' => $comments
        ]);

    }
    
    
    public function replay(Review $review,Request $request){

        $this->validate($request,[
            'text' => 'required|string',
        ]);


        Review::create([
            'text' => $request->text,
            'name' => '-',
            'product_id' => $review->product_id,
            'user_id' => auth()->user()->id,
            'confirmed' => 1,
            'replay_id' => $review->id
        ]);
        alert()->flash('ویرایش شد', 'success', [
            'text' => 'پاسخ ثبت شد.',
            'timer' => 2000
        ]);
        return back();
    }

    protected function deleteReplay(Review $review){

        $review->delete();
        return back();

    }

}
