<?php
/**
 * Created by PhpStorm.
 * User: saeed
 * Date: 3/18/2018
 * Time: 1:44 PM
 */

namespace App\Http\Controllers\CrmSiteFront\Baners;

use App\Models\Baner;
use App\Models\Category;
use App\Models\StuffType;
use Illuminate\Http\Request;
use Validator;

class CategoryController extends BanersController
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $stuffTypes = StuffType::all();
        $baners = Baner::whereType('category')->get();
        return view('CRM.SiteFront.baners.category.index', compact(
            'baners', 'stuffTypes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'name' => 'required',
            'url' => 'required',
            'stuffType_id' => 'required|integer',
            'category_id' => 'required|integer',
            'image' => 'required|mimes:jpeg,bmp,png|max:1000',
        ]);
        if ($validator->fails()) {
            return back()
                ->withErrors($validator)
                ->withInput();
        }

        $path = $this->uploadImages($request->file('image'), $request->width, $request->heigt);


        Baner::create(
            [
                'stuffType_id' => $request->stuffType_id,
                'category_id' => $request->category_id,
                'type' => $request->type,
                'name' => "$request->name",
                'image_path' => $path,
                'url' => $request->url,
                'title' => $request->title
            ]
        );

        alert()->flash('با موفقیت ثبت شد.', 'success', [
            'text' => "     ",
            'type' => 'success',
            'timer' => 1400,

        ]);

        return back();
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $stuffTypes = StuffType::all();
        $baner = Baner::find($id);
        return view('CRM.SiteFront.baners.category.edit', compact(
            'baner', 'stuffTypes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $banner = Baner::find($id);

        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'name' => 'required',
            'url' => 'required',
            'stuffType_id' => 'required|integer',
            'category_id' => 'required|integer',
            'image' => 'mimes:jpeg,bmp,png|max:1000',
        ]);
        if ($validator->fails()) {
            return back()
                ->withErrors($validator)
                ->withInput();
        }

        $image = $request->file('image');
        if (isset($image)) {
            if ($banner) {
                \File::delete(public_path() . $banner->image_path);
            }

            $path = $this->uploadImages($request->file('image'), $request->width, $request->heigt);

        } else {
            $path = $banner->image_path;
        }

        $banner->update(
            [
                'stuffType_id' => $request->stuffType_id,
                'category_id' => $request->category_id,
                'type' => $request->type,
                'name' => "$request->name",
                'image_path' => $path,
                'url' => $request->url,
                'title' => $request->title
            ]
        );
        alert()->flash('انجام شد!', 'success', [
            'text' => "     ",
            'type' => 'success',
            'timer' => 1400,

        ]);

        return redirect(route('banners-category.index'));


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $baner = Baner::find($id);
        \File::delete(public_path() . $baner->image_path);

        deleteRecord($baner);

        return back();
    }

    public function ajax(Request $request)
    {
        $categorys = Category::where('stuffType_id', $request->stuffType)->get();

        return $categorys;
    }
}
