<?php

namespace App\Http\Controllers\CrmSiteFront\Baners;

use App\Http\Controllers\Controller;
use App\Models\Baner;
use App\Models\StuffType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use Validator;

class BanersController extends Controller
{
    public function index()
    {
        $baners = Baner::whereType('home')->get();
        return view('CRM.SiteFront.baners.home.index', compact(
            'baners'));
    }

    /**
     * @param Baner $baners
     * @return $this
     */
    public function store(Request $request)
    {

        $banner = Baner::whereName($request->name)->first();

        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'name' => 'required',
            'url' => 'required',
            'image' => 'mimes:jpeg,bmp,png|max:1000',
        ]);
        if ($validator->fails()) {
            return back()
                ->withErrors($validator)
                ->withInput();
        }
        $image = $request->file('image');
        if (isset($image)) {
            if ($banner) {
                \File::delete(public_path() . $banner->image_path);
            }

            $path = $this->uploadImages($request->file('image'), $request->width, $request->heigt);

        } else {
            $path = $banner->image_path;
        }
        Baner::updateOrCreate(['name' => $request->name],
            [
                'stuffType_id' => $request->stuffType_id,
                'category_id' => $request->category_id,
                'type' => $request->type,
                'name' => "$request->name",
                'image_path' => $path,
                'url' => $request->url,
                'title' => $request->title
            ]
        );
        $message = "با موفقیت ویرایش شد.    ";
        $messageType = "success";
        session()->flash('message', $message);
        session()->flash('messageType', $messageType);

        return back();
    }

    public function blog_index()
    {
        $baners = Baner::whereType('article')->get();
        return view('CRM.SiteFront.baners.blog.index', compact(
            'baners'));
    }


    public function update(Request $request, $id)
    {

        $banner = Baner::find($id);


        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'url' => 'required',
            'image' => 'mimes:jpeg,bmp,png',
        ]);
        if ($validator->fails()) {
            return back()
                ->withErrors($validator)
                ->withInput();
        }
        $image = $request->file('image');
        if (isset($image)) {
            if ($banner) {
                \File::delete(public_path() . $banner->image_path);
            }

            $path = $this->uploadImages($request->file('image'), $request->width, $request->heigt);

        } else {
            $path = $banner->image_path;
        }
        Baner::updateOrCreate(
            ['name' => $request->name],
            ['name' => "$request->name", 'image_path' => $path, 'url' => $request->url, 'title' => $request->title]
        );
        $message = "با موفقیت ویرایش شد.    ";
        $messageType = "success";
        session()->flash('message', $message);
        session()->flash('messageType', $messageType);

        return back();
    }

    protected function uploadImages($file, $width, $height)

    {
        $imagePath = '/app/banners/';

        File::exists(public_path($imagePath)) or File::makeDirectory(public_path($imagePath));


//-------------------big-----------------\

        $fileName1 = rand(0,999)."_".time().'.'.$file->getClientOriginalExtension();


        $resize_filePath = public_path('/app/banners/' . $fileName1);

        $resize_dirPath = 'app/banners';
        $file->move($resize_dirPath,$fileName1);
//        $this->resizeImage($file, $resize_dirPath, $resize_filePath, $width, $height);
        $public_path = '/app/banners/' . $fileName1;
        return $public_path;
    }

    protected static function resizeImage($file, $resize_dirPath, $resize_filePath, $width, $height)
    {
        File::exists(public_path($resize_dirPath)) or File::makeDirectory(public_path($resize_dirPath));
// open an image file
        $img = Image::make($file->getRealPath());

// now you are able to resize the instance
        $img->resize($width, $height);

//save image to resize_filePath
        $img->save($resize_filePath,100);

    }
}
